/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.alipay;

import aurora.plugin.alipay.AlipayConfig;
import aurora.plugin.alipay.AlipayUtil;
import aurora.service.ServiceContext;
import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceInstance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class AlipayRefund
extends AbstractEntry {
    private String batch_no;
    private String batch_num;
    private String detail_data;
    private String notify_url;

    public void run(ProcedureRunner runner) throws Exception {
        CompositeMap context = runner.getContext();
        HttpServiceInstance serviceInstance = (HttpServiceInstance)ServiceInstance.getInstance((CompositeMap)context);
        HttpServletRequest request = serviceInstance.getRequest();
        request.setCharacterEncoding("UTF-8");
        ServiceContext service = ServiceContext.createServiceContext((CompositeMap)context);
        CompositeMap model = service.getModel();
        String batch_no = this.getValue(context, this.getBatch_no());
        String date_batch_no = AlipayUtil.getBatchNO(batch_no);
        HashMap<String, String> sParaTemp = new HashMap<String, String>();
        sParaTemp.put("batch_no", date_batch_no);
        sParaTemp.put("batch_num", this.getValue(context, this.getBatch_num()));
        sParaTemp.put("detail_data", this.getValue(context, this.getDetail_data()));
        sParaTemp.put("refund_date", AlipayUtil.getCurrentDate());
        sParaTemp.put("notify_url", this.getValue(context, this.getNotify_url()));
        sParaTemp.put("service", "refund_fastpay_by_platform_pwd");
        sParaTemp.put("partner", AlipayConfig.partner);
        sParaTemp.put("seller_email", AlipayConfig.seller_email);
        sParaTemp.put("seller_user_id", AlipayConfig.seller_user_id);
        sParaTemp.put("_input_charset", AlipayConfig.input_charset);
        String anti_phishing_key = AlipayUtil.query_timestamp();
        String exter_invoke_ip = AlipayUtil.getIp();
        sParaTemp.put("anti_phishing_key", anti_phishing_key);
        sParaTemp.put("exter_invoke_ip", exter_invoke_ip);
        Map<String, String> sPara = AlipayUtil.buildRequestPara(sParaTemp);
        model.put((Object)"gateway", (Object)AlipayConfig.alipay_gateway);
        ArrayList keys = new ArrayList(sPara.keySet());
        int i = 0;
        while (i < keys.size()) {
            String name = (String)keys.get(i);
            String value = sPara.get(name);
            model.put((Object)name, (Object)value);
            ++i;
        }
    }

    private String getValue(CompositeMap context, String key) {
        if (key != null) {
            return TextParser.parse((String)key, (CompositeMap)context);
        }
        return null;
    }

    public String getBatch_no() {
        return this.batch_no;
    }

    public void setBatch_no(String batchNo) {
        this.batch_no = batchNo;
    }

    public String getBatch_num() {
        return this.batch_num;
    }

    public void setBatch_num(String batchNum) {
        this.batch_num = batchNum;
    }

    public String getDetail_data() {
        return this.detail_data;
    }

    public void setDetail_data(String detailData) {
        this.detail_data = detailData;
    }

    public String getNotify_url() {
        return this.notify_url;
    }

    public void setNotify_url(String notifyUrl) {
        this.notify_url = notifyUrl;
    }
}

