/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.export.task;

import java.io.File;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;
import uncertain.util.resource.ILocatable;

public class ReportRemove
extends AbstractEntry {
    public String fullPath;

    public void run(ProcedureRunner runner) throws Exception {
        boolean is_success;
        if (this.fullPath == null) {
            throw BuiltinExceptionFactory.createAttributeMissing((ILocatable)this, (String)"fullPath");
        }
        this.fullPath = TextParser.parse((String)this.fullPath, (CompositeMap)runner.getContext());
        if (!this.validateFileExtension(this.fullPath)) {
            throw new IllegalArgumentException("This file '" + this.fullPath + "' is not an report file!");
        }
        ILogger logger = LoggingContext.getLogger((CompositeMap)runner.getContext(), (String)((Object)((Object)this)).getClass().getCanonicalName());
        File file = new File(this.fullPath);
        if (!file.exists()) {
            logger.warning("This file '" + this.fullPath + "' is not exist!");
        }
        if (!(is_success = file.delete())) {
            logger.warning("This file '" + this.fullPath + "' can not be deleted!");
        }
    }

    private boolean validateFileExtension(String fileName) {
        if (fileName == null) {
            return false;
        }
        return fileName.toLowerCase().endsWith(".xls") || fileName.toLowerCase().endsWith(".xlsx");
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }
}

