/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.export.word.wml;

import aurora.plugin.export.word.WordUtils;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;

@XmlRootElement(name="t")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Text {
    private static final ArrayList<String> wordFonts = new ArrayList(Arrays.asList("\u5b8b\u4f53", "\u9ed1\u4f53", "\u5fae\u8f6f\u96c5\u9ed1"));
    private static final ArrayList<String> pdfFonts = new ArrayList(Arrays.asList("SimSun", "SimHei", "Microsoft YaHei"));
    @XmlAttribute
    private Boolean fldCharType = false;
    @XmlAttribute
    private Boolean bold = false;
    @XmlAttribute
    private String fontFamily = "SimSun";
    @XmlAttribute
    private String fontSize = "24";
    @XmlAttribute
    private String fontColor = "000000";
    @XmlAttribute
    private String underline;
    @XmlAttribute
    private Boolean italic = false;
    @XmlAttribute
    private String space;
    @XmlValue
    private String text = "";

    public Text() {
    }

    public Text(String text) {
        this.text = text;
    }

    public Boolean isBold() {
        return this.bold;
    }

    public void setBold(Boolean bold) {
        this.bold = bold;
    }

    public String getFontFamily() {
        int index;
        if ("word".equals(WordUtils.getObject("KEY_EXPORT_TYPE"))) {
            int index2 = pdfFonts.indexOf(this.fontFamily);
            if (index2 != -1) {
                this.fontFamily = wordFonts.get(index2);
            }
        } else if ("pdf".equals(WordUtils.getObject("KEY_EXPORT_TYPE")) && (index = wordFonts.indexOf(this.fontFamily)) != -1) {
            this.fontFamily = pdfFonts.get(index);
        }
        return this.fontFamily;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    public String getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(String fontSize) {
        this.fontSize = fontSize;
    }

    public String getUnderline() {
        return this.underline;
    }

    public void setUnderline(String underline) {
        this.underline = underline;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(String fontColor) {
        this.fontColor = fontColor;
    }

    public String getSpace() {
        return this.space;
    }

    public void setSpace(String space) {
        this.space = space;
    }

    public Boolean isItalic() {
        return this.italic;
    }

    public void setItalic(Boolean italic) {
        this.italic = italic;
    }

    public Boolean getFldCharType() {
        return this.fldCharType;
    }

    public void setFldCharType(Boolean fldCharType) {
        this.fldCharType = fldCharType;
    }
}

