/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sap.sync.idoc;

import aurora.plugin.sap.sync.idoc.IDocFileListener;
import aurora.plugin.sap.sync.idoc.IDocServerManager;

public class ListenerMonitor
extends Thread {
    private IDocServerManager idocServerManager;
    private IDocFileListener listener;
    private int minReconnectTime;
    private int maxReconnectTime;
    private int nextReconnectTime = 0;

    public ListenerMonitor(IDocServerManager idocServerManager, IDocFileListener listener) {
        this.idocServerManager = idocServerManager;
        this.listener = listener;
        this.minReconnectTime = idocServerManager.getReconnectTime();
        this.maxReconnectTime = idocServerManager.getMaxReconnectTime();
    }

    @Override
    public void run() {
        while (this.idocServerManager.isRunning()) {
            if (this.listener.isRunning()) {
                this.nextReconnectTime = this.minReconnectTime;
                this.sleepOneSecond();
                continue;
            }
            this.startServer();
        }
    }

    private void sleepOneSecond() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void startServer() {
        int thisReconnectTime = this.computeConnectTime();
        try {
            Thread.sleep(thisReconnectTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.listener.start();
    }

    private int computeConnectTime() {
        int thisReconnectTime = this.nextReconnectTime;
        if (thisReconnectTime == 0) {
            this.nextReconnectTime = this.minReconnectTime;
        } else if (this.nextReconnectTime < this.maxReconnectTime) {
            this.nextReconnectTime = this.nextReconnectTime * 2 <= this.maxReconnectTime ? (this.nextReconnectTime *= 2) : this.maxReconnectTime;
        }
        return thisReconnectTime;
    }
}

