/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.script;

import aurora.bm.BusinessModel;
import aurora.database.profile.IDatabaseFactory;
import aurora.plugin.script.engine.ScriptRunner;
import aurora.plugin.script.scriptobject.ScriptShareObject;
import aurora.service.ServiceThreadLocal;
import java.util.logging.Level;
import uncertain.composite.CompositeMap;
import uncertain.core.UncertainEngine;
import uncertain.ocm.IConfigurable;
import uncertain.ocm.IObjectRegistry;

public class BmScript
implements IConfigurable {
    IDatabaseFactory mFactory;
    CompositeMap mContext;
    ScriptRunner mScriptRunner;
    String mScript;
    String mImport;
    private IObjectRegistry mObjectRegistry;

    public String getImport() {
        return this.mImport;
    }

    public void setImport(String mImport) {
        this.mImport = mImport;
    }

    String getGlobalOption(String key, String default_value) {
        String value = (String)this.mFactory.getProperty(key);
        return value == null ? default_value : value;
    }

    public BmScript(IDatabaseFactory fact, IObjectRegistry ior) {
        this.mFactory = fact;
        this.mObjectRegistry = ior;
        this.mContext = ServiceThreadLocal.getCurrentThreadContext();
    }

    public void onPrepareBusinessModel(BusinessModel model) {
        String string = "var $this=$ctx.sso.get('BusinessModel');" + this.mScript;
        this.mScriptRunner = new ScriptRunner(string, this.mContext, this.mObjectRegistry);
        try {
            try {
                ScriptShareObject sso = (ScriptShareObject)this.mContext.get((Object)"sso");
                sso.put("BusinessModel", model);
                this.mScriptRunner.run();
            }
            catch (Exception e) {
                e.printStackTrace();
                UncertainEngine engine = (UncertainEngine)this.mObjectRegistry.getInstanceOfType(UncertainEngine.class);
                engine.getLogger(this.getClass().getSimpleName()).log(Level.SEVERE, e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        finally {
            model.makeReady();
        }
    }

    public void endConfigure() {
    }

    public void beginConfigure(CompositeMap config) {
        this.mScript = config.getText();
        if (this.mScript == null) {
            this.mScript = "";
        }
    }
}

