/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sessionmanager;

import aurora.plugin.sessionmanager.ExpiredSessionRegistry;
import aurora.service.IServiceFactory;
import aurora.service.ServiceInstance;
import aurora.service.ServiceInvoker;
import aurora.service.http.HttpServiceInstance;
import java.util.Collection;
import javax.servlet.http.HttpSession;
import uncertain.composite.CompositeMap;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.AbstractEntry;
import uncertain.proc.IProcedureManager;
import uncertain.proc.Procedure;
import uncertain.proc.ProcedureConfigManager;
import uncertain.proc.ProcedureRunner;

public class ExpiredSessionChecker
extends AbstractEntry {
    private IObjectRegistry objectRegistry;
    private ExpiredSessionRegistry esRegistry;
    private CompositeMap postChecker;
    String resultPath = "/parameter/@expired_aurora_session_id";

    public ExpiredSessionChecker(IObjectRegistry objectRegistry, ExpiredSessionRegistry esRegistry) {
        this.objectRegistry = objectRegistry;
        this.esRegistry = esRegistry;
    }

    public void run(ProcedureRunner runner) throws Exception {
        CompositeMap context = runner.getContext();
        HttpServiceInstance svc = (HttpServiceInstance)ServiceInstance.getInstance((CompositeMap)context);
        HttpSession session = svc.getRequest().getSession(false);
        if (session == null) {
            return;
        }
        Long sessionIdLong = (Long)session.getAttribute("aurora_session_id");
        if (sessionIdLong == null) {
            return;
        }
        String sessionId = sessionIdLong.toString();
        boolean isExpiredSession = this.esRegistry.isExpiredSession(sessionId);
        if (!isExpiredSession) {
            return;
        }
        session.invalidate();
        this.esRegistry.removeExpiredSession(sessionId);
        if (this.postChecker == null) {
            return;
        }
        context.putObject("/oneUserOneSession/@is_expired", (Object)"Y", true);
        this.executeProc(context, sessionId);
    }

    public String getResultPath() {
        return this.resultPath;
    }

    public void setResultPath(String resultPath) {
        this.resultPath = resultPath;
    }

    public CompositeMap getPostChecker() {
        return this.postChecker;
    }

    public void setPostChecker(CompositeMap postChecker) {
        this.postChecker = postChecker;
    }

    private void executeProc(CompositeMap context, String sessionId) throws Exception {
        IProcedureManager procedureManager = (IProcedureManager)this.objectRegistry.getInstanceOfType(IProcedureManager.class);
        IServiceFactory serviceFactory = (IServiceFactory)this.objectRegistry.getInstanceOfType(IServiceFactory.class);
        CompositeMap proc_config = ProcedureConfigManager.createConfigNode((String)"procedure");
        proc_config.addChilds((Collection)this.postChecker.getChilds());
        Procedure proc = procedureManager.createProcedure(proc_config);
        CompositeMap fakeContext = (CompositeMap)context.clone();
        fakeContext.putObject(this.resultPath, (Object)sessionId, true);
        ServiceInvoker.invokeProcedureWithTransaction((String)"postChecker", (Procedure)proc, (IServiceFactory)serviceFactory, (CompositeMap)fakeContext);
    }
}

