/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sessionmanager;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpSession;
import uncertain.core.ILifeCycle;
import uncertain.ocm.AbstractLocatableObject;

public class ExpiredSessionRegistry
extends AbstractLocatableObject
implements ILifeCycle {
    private String topic;
    private String message;
    private Long timeOut = 10800000L;
    private ConcurrentHashMap<String, Long> expiredSessionHashMap = new ConcurrentHashMap();
    ScheduledExecutorService service;

    public void addExpiredSession(String sessionId) {
        if (sessionId != null && !"".equals(sessionId)) {
            this.expiredSessionHashMap.put(sessionId, System.currentTimeMillis());
        }
    }

    public void removeExpiredSession(String sessionId) {
        if (sessionId != null && !"".equals(sessionId)) {
            this.expiredSessionHashMap.remove(sessionId);
        }
    }

    public boolean isExpiredSession(HttpSession session) {
        String sessionId = session.getId();
        return this.expiredSessionHashMap.keySet().contains(sessionId);
    }

    public boolean isExpiredSession(String sessionId) {
        return this.expiredSessionHashMap.keySet().contains(sessionId);
    }

    public boolean startup() {
        this.addScheduledService();
        return true;
    }

    private void addScheduledService() {
        this.service = Executors.newScheduledThreadPool(1);
        this.service.scheduleWithFixedDelay(new RemoveSession(), 1L, this.timeOut, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.expiredSessionHashMap.clear();
        this.service.shutdown();
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Long getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(Long timeOut) {
        this.timeOut = timeOut;
    }

    class RemoveSession
    implements Runnable {
        RemoveSession() {
        }

        @Override
        public void run() {
            Long currentTime = System.currentTimeMillis();
            Iterator it = ExpiredSessionRegistry.this.expiredSessionHashMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Long putTime = (Long)entry.getValue();
                if (currentTime <= putTime + ExpiredSessionRegistry.this.timeOut) continue;
                it.remove();
            }
        }
    }
}

