/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sharepoint;

import aurora.plugin.sharepoint.GetItem;
import aurora.plugin.sharepoint.SharePointConfig;
import aurora.plugin.sharepoint.SharepointAuthenticator;
import aurora.plugin.sharepoint.WebServiceUtil;
import com.microsoft.schemas.sharepoint.CopySoap;
import com.microsoft.schemas.sharepoint.FieldInformationCollection;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.CookieManager;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;
import sun.misc.BASE64Decoder;
import uncertain.composite.CompositeMap;
import uncertain.logging.ILogger;

public class Download {
    private SharePointConfig spConfig;
    private String fileFullPath;
    private ILogger logger;

    public Download(SharePointConfig spConfig, String fileFullPath) {
        this.spConfig = spConfig;
        this.fileFullPath = fileFullPath;
        this.logger = spConfig.getLogger(this.getClass().getCanonicalName());
    }

    public byte[] execute() throws Exception {
        if (this.spConfig.isUseJax()) {
            CookieManager cm = new CookieManager();
            CookieHandler.setDefault(cm);
            Authenticator.setDefault(new SharepointAuthenticator(this.spConfig));
            return this.getFileByJAX(this.fileFullPath);
        }
        return this.getFile(this.fileFullPath);
    }

    private byte[] getFileByJAX(String remotefilePath) throws Exception {
        String user_name = this.spConfig.getUserName();
        String pass_word = this.spConfig.getPassword();
        String copy_asmx_url = this.spConfig.getCopyOperationFullPath();
        byte[] fileBytes = null;
        CopySoap copySoap = this.spConfig.getCopySoap();
        BindingProvider bp = (BindingProvider)copySoap;
        bp.getRequestContext().put("javax.xml.ws.security.auth.username", user_name);
        bp.getRequestContext().put("javax.xml.ws.security.auth.password", pass_word);
        bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", copy_asmx_url);
        FieldInformationCollection fields = new FieldInformationCollection();
        byte[] a = null;
        Holder stream = new Holder((Object)a);
        Holder fields1 = new Holder((Object)fields);
        Holder getItemResult = new Holder((Object)new Long(-1L));
        copySoap.getItem(remotefilePath, (Holder<Long>)getItemResult, (Holder<FieldInformationCollection>)fields1, (Holder<byte[]>)stream);
        fileBytes = (byte[])stream.value;
        return fileBytes;
    }

    private byte[] getFile(String remotefilePath) throws Exception {
        byte[] fileBytes = null;
        String user_name = this.spConfig.getUserName();
        String pass_word = this.spConfig.getPassword();
        String copy_asmx_url = this.spConfig.getCopyOperationFullPath();
        WebServiceUtil webServiceUtil = new WebServiceUtil(user_name, pass_word);
        CompositeMap requestBody = GetItem.downloadFile(this.fileFullPath);
        this.logger.config("request:" + requestBody.toXML());
        CompositeMap response_node = webServiceUtil.request(copy_asmx_url, GetItem.SOAP_ACTION, requestBody);
        CompositeMap stream_node = (CompositeMap)response_node.getObject("Stream");
        if (stream_node == null) {
            return null;
        }
        String fileContent = stream_node.getText();
        if (fileContent == null) {
            return null;
        }
        BASE64Decoder base64 = new BASE64Decoder();
        fileBytes = base64.decodeBuffer(fileContent);
        return fileBytes;
    }
}

