/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sharepoint;

import aurora.service.ServiceThreadLocal;
import com.microsoft.schemas.sharepoint.Copy;
import com.microsoft.schemas.sharepoint.CopySoap;
import com.microsoft.schemas.sharepoint.Lists;
import com.microsoft.schemas.sharepoint.ListsSoap;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import uncertain.composite.CompositeMap;
import uncertain.core.ILifeCycle;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.util.resource.ILocatable;

public class SharePointConfig
extends AbstractLocatableObject
implements ILifeCycle {
    public static String COPY_WSDL = "/_vti_bin/copy.asmx?wsdl";
    public static String COPY_OPERATION = "/_vti_bin/Copy.asmx";
    public static String LISTS_WSDL = "/_vti_bin/lists.asmx?wsdl";
    public static String LISTS_OPERATION = "/_vti_bin/Lists.asmx";
    public static QName COPY_QNAME = new QName("http://schemas.microsoft.com/sharepoint/soap/", "Copy");
    public static QName LISTS_QNAME = new QName("http://schemas.microsoft.com/sharepoint/soap/", "Lists");
    public static String DEFAULT_SYSTEM = "Aurora";
    private String userName;
    private String password;
    private String appLocation;
    private String copyWsdlFullPath;
    private String copyOperationFullPath;
    private String listsWsdlFullPath;
    private String listsOperationFullPath;
    private String sourceSystem;
    private boolean useJax = false;
    private static ListsSoap listsSoap;
    private static CopySoap copySoap;
    private ConcurrentLinkedQueue<String> existsFolder = new ConcurrentLinkedQueue();
    private long cacheFolderLength = 1000L;
    private CompositeMap spLists = new CompositeMap();

    public boolean startup() {
        if (this.appLocation == null) {
            throw BuiltinExceptionFactory.createAttributeMissing((ILocatable)this, (String)"appLocation");
        }
        if (this.copyWsdlFullPath == null) {
            this.copyWsdlFullPath = String.valueOf(this.appLocation) + COPY_WSDL;
        }
        if (this.copyOperationFullPath == null) {
            this.copyOperationFullPath = String.valueOf(this.appLocation) + COPY_OPERATION;
        }
        if (this.listsWsdlFullPath == null) {
            this.listsWsdlFullPath = String.valueOf(this.appLocation) + LISTS_WSDL;
        }
        if (this.listsOperationFullPath == null) {
            this.listsOperationFullPath = String.valueOf(this.appLocation) + LISTS_OPERATION;
        }
        if (this.sourceSystem == null) {
            this.sourceSystem = DEFAULT_SYSTEM;
        }
        return true;
    }

    public void shutdown() {
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAppLocation() {
        return this.appLocation;
    }

    public void setAppLocation(String appLoc) {
        if (appLoc.endsWith("/")) {
            appLoc = appLoc.substring(0, appLoc.length() - 1);
        }
        this.appLocation = appLoc;
    }

    public String getCopyWsdlFullPath() {
        return this.copyWsdlFullPath;
    }

    public void setCopyWsdlFullPath(String copyWsdlFullPath) {
        this.copyWsdlFullPath = copyWsdlFullPath;
    }

    public String getCopyOperationFullPath() {
        return this.copyOperationFullPath;
    }

    public void setCopyOperationFullPath(String copyOperationFullPath) {
        this.copyOperationFullPath = copyOperationFullPath;
    }

    public String getListsWsdlFullPath() {
        return this.listsWsdlFullPath;
    }

    public void setListsWsdlFullPath(String listsWsdlFullPath) {
        this.listsWsdlFullPath = listsWsdlFullPath;
    }

    public String getListsOperationFullPath() {
        return this.listsOperationFullPath;
    }

    public void setListsOperationFullPath(String listsOperationFullPath) {
        this.listsOperationFullPath = listsOperationFullPath;
    }

    public String getSourceSystem() {
        return this.sourceSystem;
    }

    public void setSourceSystem(String sourceSystem) {
        this.sourceSystem = sourceSystem;
    }

    public long getCacheFolderLength() {
        return this.cacheFolderLength;
    }

    public void setCacheFolderLength(long cacheFolderLength) {
        this.cacheFolderLength = cacheFolderLength;
    }

    public boolean getUseJax() {
        return this.useJax;
    }

    public boolean isUseJax() {
        return this.useJax;
    }

    public void setUseJax(boolean useJax) {
        this.useJax = useJax;
    }

    public byte[] fileToBytes(File file) throws IOException {
        ByteArrayOutputStream ous = null;
        FileInputStream ios = null;
        try {
            byte[] buffer = new byte[4096];
            ous = new ByteArrayOutputStream();
            ios = new FileInputStream(file);
            int read = 0;
            while ((read = ((InputStream)ios).read(buffer)) != -1) {
                ous.write(buffer, 0, read);
            }
        }
        catch (Throwable throwable) {
            SharePointConfig.close(ous);
            SharePointConfig.close(ios);
            throw throwable;
        }
        SharePointConfig.close(ous);
        SharePointConfig.close(ios);
        return ous.toByteArray();
    }

    public byte[] inputStreamToBytes(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int i = -1;
            while ((i = is.read()) != -1) {
                baos.write(i);
            }
        }
        finally {
            SharePointConfig.close(is);
            SharePointConfig.close(baos);
        }
        return baos.toByteArray();
    }

    public static Node createSharePointCAMLNode(String theXML) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(new StringReader(theXML)));
        Element node = document.getDocumentElement();
        return node;
    }

    public static void findAllElementsByTagName(Element el, String tagName, List<Element> elementList) {
        if (tagName.equals(el.getTagName())) {
            elementList.add(el);
        }
        Element elem = SharePointConfig.getFirstElement(el);
        while (elem != null) {
            SharePointConfig.findAllElementsByTagName(elem, tagName, elementList);
            elem = SharePointConfig.getNextElement(elem);
        }
    }

    public static Element getNextElement(Element el) {
        Node nd = el.getNextSibling();
        while (nd != null) {
            if (nd.getNodeType() == 1) {
                return (Element)nd;
            }
            nd = nd.getNextSibling();
        }
        return null;
    }

    public static Element getFirstElement(Node parent) {
        Node n = parent.getFirstChild();
        while (n != null && 1 != n.getNodeType()) {
            n = n.getNextSibling();
        }
        if (n == null) {
            return null;
        }
        return (Element)n;
    }

    public static void close(Closeable resource) {
        if (resource == null) {
            return;
        }
        try {
            resource.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void checkCacheFolderLength() {
        while ((long)this.existsFolder.size() > this.cacheFolderLength) {
            this.existsFolder.poll();
        }
    }

    public void addFolder(String folder) {
        if (this.existsFolder.contains(folder)) {
            return;
        }
        this.checkCacheFolderLength();
        this.existsFolder.add(folder);
    }

    public void addAllFolder(Collection<String> c) {
        this.checkCacheFolderLength();
        this.existsFolder.addAll(c);
    }

    public void removeFolder(String folder) {
        this.existsFolder.remove(folder);
    }

    public boolean isFolderExists(String folder) {
        return this.existsFolder.contains(folder);
    }

    public CompositeMap getLists() {
        return this.spLists;
    }

    public void setLists(CompositeMap lists) {
        if (lists == null) {
            return;
        }
        List childs = lists.getChilds();
        if (childs == null) {
            return;
        }
        for (CompositeMap list : childs) {
            this.spLists.put((Object)list.getString((Object)"url"), (Object)list.getString((Object)"name"));
        }
    }

    public String getListName(String listUrl) {
        return this.spLists.getString((Object)listUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListsSoap getListsSoap() throws Exception {
        if (listsSoap == null) {
            SharePointConfig sharePointConfig = this;
            synchronized (sharePointConfig) {
                Lists service = new Lists(new URL(this.listsWsdlFullPath), LISTS_QNAME);
                listsSoap = service.getListsSoap();
            }
        }
        return listsSoap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CopySoap getCopySoap() throws Exception {
        if (copySoap == null) {
            SharePointConfig sharePointConfig = this;
            synchronized (sharePointConfig) {
                Copy service = new Copy(new URL(this.copyWsdlFullPath), COPY_QNAME);
                copySoap = service.getCopySoap();
            }
        }
        return copySoap;
    }

    public ILogger getLogger(String topic) {
        CompositeMap context = ServiceThreadLocal.getCurrentThreadContext();
        return LoggingContext.getLogger((CompositeMap)context, (String)topic);
    }

    public void writeResult(Object result, OutputStream stream) throws Exception {
        if (result == null) {
            return;
        }
        if (!(result instanceof Element)) {
            return;
        }
        Element e = (Element)result;
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.transform(new DOMSource(e.getOwnerDocument()), new StreamResult(new OutputStreamWriter(stream, "UTF-8")));
    }

    public String parseResult(Object response) throws Exception {
        if (response == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream pw = new PrintStream(baos);
        this.writeResult(response, pw);
        pw.close();
        return baos.toString();
    }
}

