/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sharepoint;

import aurora.plugin.sharepoint.SharePointConfig;

public class SharePointFile {
    private SharePointConfig spConfig;
    private String fileFullPath;
    private String folderPath;
    private String listName;
    private String listUrl;
    private String fileName;

    public SharePointFile(SharePointConfig spConfig, String fileFullPath) {
        this.spConfig = spConfig;
        this.fileFullPath = fileFullPath;
        this.init(fileFullPath);
    }

    public String getFileFullPath() {
        return this.fileFullPath;
    }

    public void setFileFullPath(String fileFullPath) {
        this.fileFullPath = fileFullPath;
    }

    public String getFolderPath() {
        return this.folderPath;
    }

    public void setFolderPath(String folderPath) {
        this.folderPath = folderPath;
    }

    public String getListName() {
        return this.listName;
    }

    public void setListName(String listName) {
        this.listName = listName;
    }

    public String getListUrl() {
        return this.listUrl;
    }

    public void setListUrl(String listUrl) {
        this.listUrl = listUrl;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    private void init(String fileFullPath) {
        String appLocation = this.spConfig.getAppLocation();
        int appLocationIndex = fileFullPath.indexOf(appLocation) + appLocation.length() + 1;
        if (appLocationIndex <= appLocation.length()) {
            return;
        }
        int folderPathIndex = fileFullPath.indexOf("/", appLocationIndex);
        this.listUrl = fileFullPath.substring(appLocationIndex, folderPathIndex);
        this.listName = this.spConfig.getListName(this.listUrl);
        if (this.listName == null) {
            this.listName = this.listUrl;
        }
        int endIndex = fileFullPath.lastIndexOf("/");
        this.folderPath = fileFullPath.substring(folderPathIndex + 1, endIndex);
        this.fileName = fileFullPath.substring(endIndex + 1);
    }
}

