/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sharepoint;

import aurora.plugin.sharepoint.CopyIntoItems;
import aurora.plugin.sharepoint.SharePointConfig;
import aurora.plugin.sharepoint.SharePointFile;
import aurora.plugin.sharepoint.SharepointAuthenticator;
import aurora.plugin.sharepoint.UpdateListItems;
import aurora.plugin.sharepoint.WebServiceUtil;
import com.microsoft.schemas.sharepoint.CopyErrorCode;
import com.microsoft.schemas.sharepoint.CopyResult;
import com.microsoft.schemas.sharepoint.CopyResultCollection;
import com.microsoft.schemas.sharepoint.CopySoap;
import com.microsoft.schemas.sharepoint.DestinationUrlCollection;
import com.microsoft.schemas.sharepoint.FieldInformation;
import com.microsoft.schemas.sharepoint.FieldInformationCollection;
import com.microsoft.schemas.sharepoint.FieldType;
import com.microsoft.schemas.sharepoint.ListsSoap;
import com.microsoft.schemas.sharepoint.UpdateListItems;
import com.microsoft.schemas.sharepoint.UpdateListItemsResponse;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.util.LinkedList;
import java.util.List;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;
import sun.misc.BASE64Encoder;
import uncertain.composite.CompositeMap;
import uncertain.logging.ILogger;

public class Upload {
    public static String UPLOAD_SUCCESS = "Success";
    public static String CREATE_FOLDER_SUCCESS = "0x00000000";
    public static String FOLDER_EXISTS = "0x8107090d";
    private SharePointConfig spConfig;
    private SharePointFile spFile;
    private ILogger logger;
    private byte[] fileContent;
    private String sourceSystemUser;
    private String sourceSystem;
    private LinkedList<String> folders = new LinkedList();

    public Upload(SharePointConfig spConfig, SharePointFile spFile, byte[] fileContent, String sourceSystem, String sourceSystemUser) {
        this.spConfig = spConfig;
        this.spFile = spFile;
        this.logger = spConfig.getLogger(this.getClass().getCanonicalName());
        this.fileContent = fileContent;
        this.sourceSystem = sourceSystem;
        this.sourceSystemUser = sourceSystemUser;
    }

    public void execute() throws Exception {
        if (this.spConfig.isUseJax()) {
            CookieManager cm = new CookieManager();
            CookieHandler.setDefault(cm);
            Authenticator.setDefault(new SharepointAuthenticator(this.spConfig));
            String folderPath = this.spFile.getFolderPath();
            this.createFolder(folderPath);
            String fileFullPath = this.spFile.getFileFullPath();
            this.uploadFileByJAX(fileFullPath, this.fileContent, this.sourceSystem, this.sourceSystemUser);
        } else {
            String folderPath = this.spFile.getFolderPath();
            this.createFolder(folderPath);
            String fileFullPath = this.spFile.getFileFullPath();
            this.uploadFile(fileFullPath, this.fileContent, this.sourceSystem, this.sourceSystemUser);
        }
    }

    private void createFolder(String folderPath) throws Exception {
        if (this.spConfig.isFolderExists(folderPath)) {
            return;
        }
        String listName = this.spFile.getListName();
        if (this.spConfig.isUseJax()) {
            this.createFolderByJAX(listName, folderPath);
        } else {
            this.createFolder(listName, folderPath);
        }
    }

    public void createFolderByJAX(String listName, String folderPath) throws Exception {
        String user_name = this.spConfig.getUserName();
        String pass_word = this.spConfig.getPassword();
        String list_asmx_url = this.spConfig.getListsOperationFullPath();
        String[] nextFolder = folderPath.split("/");
        ListsSoap port = this.spConfig.getListsSoap();
        BindingProvider bp = (BindingProvider)port;
        bp.getRequestContext().put("javax.xml.ws.security.auth.username", user_name);
        bp.getRequestContext().put("javax.xml.ws.security.auth.password", pass_word);
        bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", list_asmx_url);
        String currentFolder = "";
        UpdateListItems.Updates u = new UpdateListItems.Updates();
        StringBuffer createfolder = new StringBuffer("<Batch OnError=\"Continue\" PreCalc=\"TRUE\" \nListVersion=\"0\" >\n");
        int i = 0;
        while (i < nextFolder.length) {
            currentFolder = i == 0 ? String.valueOf(currentFolder) + nextFolder[i] : String.valueOf(currentFolder) + "/" + nextFolder[i];
            createfolder.append("   <Method ID=\"1\" Cmd=\"New\">\n      <Field Name=\"ID\">New</Field>\n      <Field Name=\"FSObjType\">1</Field>\n      <Field Name=\"BaseName\">" + currentFolder + "</Field>\n" + "   </Method>\n");
            this.folders.add(currentFolder);
            ++i;
        }
        createfolder.append("</Batch>");
        u.getContent().add(SharePointConfig.createSharePointCAMLNode(createfolder.toString()));
        UpdateListItemsResponse.UpdateListItemsResult result = port.updateListItems(listName, u);
        this.printResponse(result);
    }

    public void createFolder(String listName, String folderPath) throws Exception {
        String user_name = this.spConfig.getUserName();
        String pass_word = this.spConfig.getPassword();
        String list_asmx_url = this.spConfig.getListsOperationFullPath();
        String currentFolder = "";
        String[] nextFolder = folderPath.split("/");
        int i = 0;
        while (i < nextFolder.length) {
            currentFolder = i == 0 ? String.valueOf(currentFolder) + nextFolder[i] : String.valueOf(currentFolder) + "/" + nextFolder[i];
            this.folders.add(currentFolder);
            ++i;
        }
        WebServiceUtil webServiceUtil = new WebServiceUtil(user_name, pass_word);
        CompositeMap requestBody = UpdateListItems.createFolders(listName, this.folders);
        this.logger.config("request:" + requestBody.toXML());
        CompositeMap response_node = webServiceUtil.request(list_asmx_url, UpdateListItems.SOAP_ACTION, requestBody);
        this.logger.config("response:" + response_node.toXML());
        CompositeMap results = (CompositeMap)response_node.getObject("UpdateListItemsResult/Results");
        if (results == null) {
            return;
        }
        List resultList = results.getChilds();
        int length = resultList.size();
        if (length <= 0) {
            return;
        }
        CompositeMap lastResult = (CompositeMap)resultList.get(length - 1);
        CompositeMap errorCode_node = lastResult.getChild("ErrorCode");
        String errorCode = errorCode_node.getText();
        this.logger.info("errorCode:" + errorCode_node);
        if (CREATE_FOLDER_SUCCESS.equals(errorCode) || FOLDER_EXISTS.equals(errorCode)) {
            return;
        }
        CompositeMap errorText_node = lastResult.getChild("ErrorText");
        String errorMessage = errorText_node.getText();
        throw new RuntimeException(errorMessage);
    }

    private void printResponse(UpdateListItemsResponse.UpdateListItemsResult result) throws Exception {
        List<Object> resultList = result.getContent();
        if (resultList == null || resultList.size() == 0) {
            return;
        }
        Object content = resultList.get(0);
        this.logger.info("createFolder:" + this.spConfig.parseResult(content));
    }

    private void uploadFileByJAX(String fileFullPath, byte[] fileContent, String sourceSystem, String sourceSystemUser) throws Exception {
        String user_name = this.spConfig.getUserName();
        String pass_word = this.spConfig.getPassword();
        String copy_asmx_url = this.spConfig.getCopyOperationFullPath();
        CopySoap copySoap = this.spConfig.getCopySoap();
        BindingProvider bp = (BindingProvider)copySoap;
        bp.getRequestContext().put("javax.xml.ws.security.auth.username", user_name);
        bp.getRequestContext().put("javax.xml.ws.security.auth.password", pass_word);
        bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", copy_asmx_url);
        DestinationUrlCollection destinationUrlCollection = new DestinationUrlCollection();
        destinationUrlCollection.getString().add(fileFullPath);
        FieldInformationCollection fields = new FieldInformationCollection();
        FieldInformation sourceInfo = new FieldInformation();
        sourceInfo.setDisplayName("\u6765\u6e90\u7cfb\u7edf");
        sourceInfo.setType(FieldType.TEXT);
        sourceInfo.setValue(sourceSystem);
        fields.getFieldInformation().add(sourceInfo);
        FieldInformation userInfo = new FieldInformation();
        userInfo.setDisplayName("\u7528\u6237\u540d");
        userInfo.setType(FieldType.TEXT);
        userInfo.setValue(sourceSystemUser);
        fields.getFieldInformation().add(userInfo);
        CopyResultCollection results = new CopyResultCollection();
        Holder resultHolder = new Holder((Object)results);
        Holder longHolder = new Holder((Object)new Long(-1L));
        copySoap.copyIntoItems("S", destinationUrlCollection, fields, fileContent, (Holder<Long>)longHolder, (Holder<CopyResultCollection>)resultHolder);
        this.spConfig.addAllFolder(this.folders);
        this.folders.clear();
        for (CopyResult copyResult : ((CopyResultCollection)resultHolder.value).getCopyResult()) {
            if (copyResult.getErrorCode() == CopyErrorCode.SUCCESS) continue;
            throw new Exception("Upload failed for: " + copyResult.getDestinationUrl() + " Message: " + copyResult.getErrorMessage() + " Code: " + (Object)((Object)copyResult.getErrorCode()));
        }
    }

    private void uploadFile(String fileFullPath, byte[] fileContent, String sourceSystem, String sourceSystemUser) throws Exception {
        String user_name = this.spConfig.getUserName();
        String pass_word = this.spConfig.getPassword();
        String copy_asmx_url = this.spConfig.getCopyOperationFullPath();
        WebServiceUtil webServiceUtil = new WebServiceUtil(user_name, pass_word);
        BASE64Encoder base64 = new BASE64Encoder();
        String stream = base64.encode(fileContent);
        CompositeMap requestBody = CopyIntoItems.uploadFile(fileFullPath, sourceSystem, sourceSystemUser, stream);
        CompositeMap response_node = webServiceUtil.request(copy_asmx_url, CopyIntoItems.SOAP_ACTION, requestBody);
        this.logger.config("response:" + response_node.toXML());
        CompositeMap results = (CompositeMap)response_node.getObject("Results");
        if (results == null) {
            return;
        }
        List resultList = results.getChilds();
        if (resultList == null) {
            return;
        }
        int length = resultList.size();
        if (length <= 0) {
            return;
        }
        CompositeMap lastResult = (CompositeMap)resultList.get(length - 1);
        String errorCode = lastResult.getString((Object)"ErrorCode");
        this.logger.info("errorCode:" + errorCode);
        if (UPLOAD_SUCCESS.equals(errorCode)) {
            return;
        }
        String errorMessage = lastResult.getString((Object)"ErrorMessage");
        throw new RuntimeException(errorMessage);
    }
}

