/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sharepoint;

import aurora.service.ServiceThreadLocal;
import aurora.service.ws.SOAPServiceInterpreter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import sun.misc.BASE64Encoder;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.composite.XMLOutputter;
import uncertain.exception.ConfigurationFileException;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;

public class WebServiceUtil {
    public static final int DEFAULT_CONNECT_TIMEOUT = 60000;
    public static final int DEFAULT_READ_TIMEOUT = 0;
    boolean raiseExceptionOnError = true;
    int connectTimeout = 60000;
    int readTimeout = 0;
    String user;
    String password;
    boolean noCDATA = false;
    public static final String WS_INVOKER_ERROR_CODE = "aurora.service.ws.invoker_error";

    public WebServiceUtil() {
    }

    public WebServiceUtil(String user, String password) {
        this.user = user;
        this.password = password;
    }

    public CompositeMap request(String requestUrl, CompositeMap requestBody) throws Exception {
        return this.request(requestUrl, "urn:anonOutInOp", requestBody);
    }

    public CompositeMap request(String requestUrl, String soapAction, CompositeMap requestBody) throws Exception {
        CompositeMap context = ServiceThreadLocal.getCurrentThreadContext();
        ILogger logger = LoggingContext.getLogger((CompositeMap)context, (String)this.getClass().getCanonicalName());
        URI uri = new URI(requestUrl);
        URL url = uri.toURL();
        OutputStreamWriter writer = null;
        InputStream inputStream = null;
        CompositeMap soapBody = this.createSOAPBody();
        soapBody.addChild(requestBody);
        String content = XMLOutputter.defaultInstance().toXML(soapBody.getRoot(), true);
        if (this.isNoCDATA()) {
            content = this.removeCDATA(content);
        }
        HttpURLConnection httpUrlConnection = null;
        try {
            CompositeMap result;
            httpUrlConnection = (HttpURLConnection)url.openConnection();
            httpUrlConnection.setDoInput(true);
            httpUrlConnection.setDoOutput(true);
            httpUrlConnection.setRequestMethod("POST");
            httpUrlConnection.setConnectTimeout(this.connectTimeout);
            httpUrlConnection.setReadTimeout(this.readTimeout);
            httpUrlConnection.setRequestProperty("Accept", "text/xml, multipart/related");
            this.addAuthorization(httpUrlConnection, context);
            httpUrlConnection.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
            httpUrlConnection.setRequestProperty("SOAPAction", "\"" + soapAction + "\"");
            httpUrlConnection.connect();
            OutputStream os = httpUrlConnection.getOutputStream();
            writer = new OutputStreamWriter(os, "UTF-8");
            writer.write("<?xml version='1.0' encoding='UTF-8'?>");
            writer.write(content);
            writer.flush();
            writer.close();
            String soapResponse = null;
            CompositeLoader cl = new CompositeLoader();
            if (200 == httpUrlConnection.getResponseCode()) {
                inputStream = httpUrlConnection.getInputStream();
                soapResponse = this.inputStream2String(inputStream);
            } else {
                inputStream = httpUrlConnection.getInputStream();
                soapResponse = this.inputStream2String(inputStream);
                if (this.raiseExceptionOnError) {
                    throw new ConfigurationFileException(WS_INVOKER_ERROR_CODE, new Object[]{url, soapResponse}, null);
                }
            }
            httpUrlConnection.disconnect();
            CompositeMap soap = cl.loadFromString(soapResponse, "UTF-8");
            CompositeMap compositeMap = result = (CompositeMap)soap.getChild(SOAPServiceInterpreter.BODY.getLocalName()).getChilds().get(0);
            this.colse(writer);
            this.colse(inputStream);
            if (httpUrlConnection != null) {
                httpUrlConnection.disconnect();
            }
            return compositeMap;
        }
        catch (Exception e) {
            try {
                logger.log(Level.SEVERE, "", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.colse(writer);
                this.colse(inputStream);
                if (httpUrlConnection != null) {
                    httpUrlConnection.disconnect();
                }
                throw throwable;
            }
        }
    }

    private CompositeMap createSOAPBody() {
        CompositeMap env = new CompositeMap(SOAPServiceInterpreter.ENVELOPE.getPrefix(), "http://schemas.xmlsoap.org/soap/envelope/", SOAPServiceInterpreter.ENVELOPE.getLocalName());
        CompositeMap body = new CompositeMap(SOAPServiceInterpreter.BODY.getPrefix(), "http://schemas.xmlsoap.org/soap/envelope/", SOAPServiceInterpreter.BODY.getLocalName());
        env.addChild(body);
        return body;
    }

    public boolean isNoCDATA() {
        return this.noCDATA;
    }

    public void setNoCDATA(boolean noCDATA) {
        this.noCDATA = noCDATA;
    }

    private String removeCDATA(String source) {
        source = source.replaceAll("<!\\[CDATA\\[", "");
        source = source.replaceAll("]]>", "");
        return source;
    }

    private void addAuthorization(HttpURLConnection httpUrlConnection, CompositeMap context) {
        if (this.user == null) {
            return;
        }
        ILogger logger = LoggingContext.getLogger((CompositeMap)context, (String)this.getClass().getCanonicalName());
        String userName = TextParser.parse((String)this.user, (CompositeMap)context);
        String passwd = TextParser.parse((String)this.password, (CompositeMap)context);
        String fullText = String.valueOf(userName) + ":" + passwd;
        logger.config("plan user/password:" + fullText);
        BASE64Encoder base64 = new BASE64Encoder();
        String decodeText = "Basic " + base64.encode(fullText.getBytes());
        logger.config("decode user/password:" + decodeText);
        httpUrlConnection.setRequestProperty("Authorization", decodeText);
    }

    public String inputStream2String(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int i = -1;
        while ((i = is.read()) != -1) {
            baos.write(i);
        }
        String result = new String(baos.toByteArray(), "UTF-8");
        return result;
    }

    private void colse(Closeable resource) {
        if (resource == null) {
            return;
        }
        try {
            resource.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

