/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.source.gen;

import aurora.bm.BusinessModel;
import aurora.bm.IModelFactory;
import aurora.plugin.source.gen.JavascriptRhino;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import uncertain.composite.CompositeMap;
import uncertain.composite.IterationHandle;
import uncertain.ocm.IObjectRegistry;

public class ModelMapParser {
    private CompositeMap modelMap;
    private IObjectRegistry registry;

    protected ModelMapParser(CompositeMap uipMap) {
        this.setUipMap(uipMap);
    }

    public ModelMapParser(IObjectRegistry registry, CompositeMap uipMap) {
        this.setUipMap(uipMap);
        this.registry = registry;
    }

    public CompositeMap getUipMap() {
        return this.modelMap;
    }

    public void setUipMap(CompositeMap uipMap) {
        this.modelMap = uipMap;
    }

    public List<CompositeMap> getComponents(String componentType) {
        return this.getComponents(this.modelMap, componentType);
    }

    private List<CompositeMap> getComponents(CompositeMap map, String componentType) {
        ArrayList<CompositeMap> result = new ArrayList<CompositeMap>();
        List childs = map.getChilds();
        if (childs != null) {
            for (Object object : childs) {
                if (!(object instanceof CompositeMap)) continue;
                String _type = ((CompositeMap)object).getString((Object)"component_type", "");
                if (_type.equalsIgnoreCase(componentType)) {
                    result.add((CompositeMap)object);
                }
                if (!this.hasChild((CompositeMap)object)) continue;
                result.addAll(this.getComponents((CompositeMap)object, componentType));
            }
        }
        return result;
    }

    private List<CompositeMap> getComponents(CompositeMap map, List<String> componentTypes) {
        ArrayList<CompositeMap> result = new ArrayList<CompositeMap>();
        List childs = map.getChilds();
        if (childs != null) {
            for (Object object : childs) {
                if (!(object instanceof CompositeMap)) continue;
                String _type = ((CompositeMap)object).getString((Object)"component_type", "");
                if (componentTypes.contains(_type.toLowerCase())) {
                    result.add((CompositeMap)object);
                }
                if (!this.hasChild((CompositeMap)object)) continue;
                result.addAll(this.getComponents((CompositeMap)object, componentTypes));
            }
        }
        return result;
    }

    public boolean hasChild(CompositeMap map) {
        List childs = map.getChilds();
        return childs != null && !childs.isEmpty();
    }

    public List<CompositeMap> getGrids() {
        return this.getComponents("grid");
    }

    public List<CompositeMap> getDatasets() {
        ArrayList<CompositeMap> datasets = new ArrayList<CompositeMap>();
        List<CompositeMap> qds = this.getComponents("querydataset");
        for (CompositeMap q : qds) {
            if (!this.isRealDataset(q)) continue;
            datasets.add(q);
        }
        List<CompositeMap> rds = this.getComponents("resultdataset");
        for (CompositeMap r : rds) {
            if (!this.isRealDataset(r)) continue;
            datasets.add(r);
        }
        return datasets;
    }

    public String getFunctionName(String script) {
        JavascriptRhino js = new JavascriptRhino(script);
        String name = js.getFirstFunctionName();
        return name == null ? "" : name;
    }

    public boolean isRealDataset(CompositeMap ds) {
        CompositeMap parent = ds.getParent();
        return this.isSectionComponent(parent);
    }

    public boolean isSectionComponent(CompositeMap parent) {
        if (parent == null) {
            return false;
        }
        String sectionType = parent.getString((Object)"container_section_type", "");
        return "SECTION_TYPE_QUERY".equalsIgnoreCase(sectionType) || "SECTION_TYPE_RESULT".equalsIgnoreCase(sectionType);
    }

    public List<CompositeMap> getDatasetFields(CompositeMap ds) {
        ArrayList<CompositeMap> fields = new ArrayList<CompositeMap>();
        CompositeMap parent = ds.getParent();
        List<CompositeMap> components = this.getComponents(parent, "datasetfield");
        for (CompositeMap f : components) {
            if (!this.hasDSFieldChild(parent, f)) continue;
            f.put((Object)"ds_markid", (Object)ds.getString((Object)"markid", ""));
            fields.add(f);
        }
        return fields;
    }

    private boolean hasDSFieldChild(CompositeMap parent, CompositeMap child) {
        if (child == null) {
            return false;
        }
        CompositeMap _p = child.getParent();
        if (parent.equals((Object)_p)) {
            return true;
        }
        if (this.isSectionComponent(_p)) {
            return false;
        }
        return this.hasDSFieldChild(parent, _p);
    }

    public CompositeMap loadModelMap(String optionModel) {
        IModelFactory instanceOfType = (IModelFactory)this.registry.getInstanceOfType(IModelFactory.class);
        try {
            BusinessModel model = instanceOfType.getModel(optionModel);
            return model.getObjectContext();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getButtonOpenParameters(CompositeMap buttonMap) {
        StringBuilder sb = new StringBuilder("");
        return "getButtonOpenParameters";
    }

    public String getButtonTargetDatasetID(final CompositeMap buttonMap) {
        CompositeMap clicker = buttonMap.getChild("inner_buttonclicker");
        if (clicker == null) {
            return "";
        }
        CompositeMap childByAttrib = clicker.getChildByAttrib((Object)"propertye_id", (Object)"button_click_target_component");
        if (childByAttrib == null) {
            return "";
        }
        final String refID = childByAttrib.getString((Object)"markid", "");
        this.modelMap.iterate(new IterationHandle(){

            public int process(CompositeMap map) {
                CompositeMap child;
                if (refID.equals(map.getString((Object)"markid")) && (child = map.getChildByAttrib((Object)"propertye_id", (Object)"i_dataset_delegate")) != null) {
                    String id = child.getString((Object)"ds_id", "");
                    buttonMap.put((Object)"ds_id", (Object)id);
                    return 2;
                }
                return 0;
            }
        }, false);
        return buttonMap.getString((Object)"ds_id", "");
    }

    public CompositeMap getComponentByID(final String markid) {
        final CompositeMap[] maps = new CompositeMap[1];
        this.modelMap.iterate(new IterationHandle(){

            public int process(CompositeMap map) {
                if (markid.equals(map.getString((Object)"markid")) && !"reference".equals(map.getName())) {
                    maps[0] = map;
                    return 2;
                }
                return 0;
            }
        }, true);
        return maps[0];
    }

    public String[] getParametersDetail(CompositeMap renderer, String string) {
        return new String[]{"aa", "bb"};
    }

    public String[] findComboFieldOption(final CompositeMap field) {
        String ds_markid = field.getString((Object)"ds_markid", "");
        CompositeMap dsMap = this.getComponentByID(ds_markid);
        String model = dsMap.getString((Object)"model", "");
        CompositeMap bmFileMap = this.loadModelMap(model);
        final String[] options = new String[]{"", ""};
        bmFileMap.iterate(new IterationHandle(){

            public int process(CompositeMap map) {
                if ("field".equalsIgnoreCase(map.getName()) && map.getString((Object)"name", "").equalsIgnoreCase(field.getString((Object)"field_name", ""))) {
                    options[0] = map.getString((Object)"options", "");
                    options[1] = ModelMapParser.this.getStringIgnoreCase(map, "lookupcode");
                    return 2;
                }
                return 0;
            }
        }, false);
        return options;
    }

    public Object getComboValueField(String[] models, CompositeMap field) {
        String model = models[0];
        if (!"".equals(model)) {
            CompositeMap modelMap = this.loadModelMap(model);
            CompositeMap child = modelMap.getChild("primary-key");
            CompositeMap child2 = child.getChild("pk-field");
            String r = child2.getString((Object)"name", "");
            return r;
        }
        return "code_value";
    }

    public Object getComboDisplayField(String[] models, CompositeMap field) {
        String model = models[0];
        if (!"".equals(model)) {
            CompositeMap modelMap = this.loadModelMap(model);
            return this.getStringIgnoreCase(modelMap, "defaultdisplayfield");
        }
        return "code_value_name";
    }

    private String getStringIgnoreCase(CompositeMap map, String key) {
        Set keySet = map.keySet();
        for (Object object : keySet) {
            if (!(object instanceof String) || !((String)object).equalsIgnoreCase(key)) continue;
            return map.getString(object);
        }
        return "";
    }
}

