/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.source.gen.screen.model;

import aurora.plugin.source.gen.screen.model.Container;
import aurora.plugin.source.gen.screen.model.Point;
import aurora.plugin.source.gen.screen.model.Rectangle;
import aurora.plugin.source.gen.screen.model.properties.PropertyEditSupport;
import java.util.HashMap;
import java.util.Map;

public abstract class AuroraComponent
extends PropertyEditSupport
implements Cloneable {
    private Map<Object, Object> simpleProperties = new HashMap<Object, Object>();
    private Container parent;
    private Rectangle bounds = Rectangle.NONE();

    public AuroraComponent() {
        this.setPropertyValue("component_marker_id", this.markid);
        this.setRowspan(1);
        this.setColspan(1);
    }

    protected Map<Object, Object> getSimpleProperties() {
        return this.simpleProperties;
    }

    protected void setSimpleProperties(Map<Object, Object> simpleProperties) {
        this.simpleProperties = simpleProperties;
    }

    protected boolean eq(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public int getIntegerPropertyValue(String propId) {
        Object x = this.getPropertyValue(propId);
        return x instanceof Integer ? (Integer)x : -1;
    }

    public Boolean getBooleanPropertyValue(String propId) {
        Object x = this.getPropertyValue(propId);
        return x instanceof Boolean ? (Boolean)x : false;
    }

    public String getStringPropertyValue(String propId) {
        Object x = this.getPropertyValue(propId);
        return x instanceof String ? x.toString() : "";
    }

    public AuroraComponent getAuroraComponentPropertyValue(String propId) {
        Object x = this.getPropertyValue(propId);
        return x instanceof AuroraComponent ? (AuroraComponent)x : null;
    }

    @Override
    public Object getPropertyValue(String propId) {
        if ("location_x".equals(propId)) {
            return this.bounds.x;
        }
        if ("location_y".equals(propId)) {
            return this.bounds.y;
        }
        if ("width".equals(propId)) {
            return this.bounds.width;
        }
        if ("height".equals(propId)) {
            return this.bounds.height;
        }
        return this.simpleProperties.get(propId);
    }

    @Override
    public void setPropertyValue(String propId, Object val) {
        if ("location_x".equals(propId) && val instanceof Integer) {
            this.bounds.x = (Integer)val;
            this.setBounds(this.bounds);
            return;
        }
        if ("location_y".equals(propId) && val instanceof Integer) {
            this.bounds.y = (Integer)val;
            this.setBounds(this.bounds);
            return;
        }
        if ("width".equals(propId) && val instanceof Integer) {
            this.setSize((Integer)val, this.bounds.height);
            return;
        }
        if ("height".equals(propId) && val instanceof Integer) {
            this.setSize(this.bounds.width, (Integer)val);
            return;
        }
        Object oldVal = this.simpleProperties.get(propId);
        if (this.eq(oldVal, val)) {
            return;
        }
        this.simpleProperties.put(propId, val);
        this.firePropertyChange(propId, oldVal, val);
    }

    public Container getParent() {
        return this.parent;
    }

    public void setParent(Container parent) {
        this.parent = parent;
    }

    public String getComponentType() {
        return this.getStringPropertyValue("component_type");
    }

    public void setComponentType(String componentType) {
        this.setPropertyValue("component_type", componentType);
    }

    public void setPrompt(String prompt) {
        this.setPropertyValue("prompt", prompt);
    }

    public void setSize(int width, int height) {
        Point old = new Point(this.bounds.width, this.bounds.height);
        this.bounds.width = width;
        this.bounds.height = height;
        this.firePropertyChange("size", old, this.bounds.getSize());
    }

    public Point getSize() {
        return this.bounds.getSize();
    }

    public void setLocation(Point p) {
        this.bounds.setLocation(p);
        this.firePropertyChange("location", p, this.bounds.getLocation());
    }

    public Point getLocation() {
        return this.bounds.getLocation();
    }

    public String getName() {
        return "" + this.getPropertyValue("name");
    }

    public String getPrompt() {
        return "" + this.getPropertyValue("prompt");
    }

    public void setName(String name) {
        this.setPropertyValue("name", name);
    }

    public void applyToModel(Rectangle bounds) {
        this.bounds = bounds.getCopy();
    }

    public Rectangle getBoundsCopy() {
        return this.bounds.getCopy();
    }

    public void setBounds(Rectangle aurora) {
        this.bounds = aurora.getCopy();
        this.firePropertyChange("component_bounds", aurora, this.bounds);
    }

    public int getColspan() {
        return this.getIntegerPropertyValue("colspan");
    }

    public void setColspan(int name) {
        this.setPropertyValue("colspan", name);
    }

    public int getRowspan() {
        return this.getIntegerPropertyValue("rowspan");
    }

    public void setRowspan(int name) {
        this.setPropertyValue("rowspan", name);
    }
}

