/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.source.gen.screen.model;

import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.Container;
import aurora.plugin.source.gen.screen.model.DatasetField;
import aurora.plugin.source.gen.screen.model.FootRenderer;
import aurora.plugin.source.gen.screen.model.IDatasetFieldDelegate;
import aurora.plugin.source.gen.screen.model.Renderer;
import aurora.plugin.source.gen.screen.model.RowCol;
import java.beans.PropertyChangeListener;

public class GridColumn
extends RowCol
implements IDatasetFieldDelegate {
    public static final String GRIDCOLUMN = "gridcolumn";
    private static final String[] editors = new String[]{"", "textField", "numberField", "comboBox", "lov", "checkBox", "datePicker", "dateTimePicker"};
    public static final String EDITOR = "editor";
    public static final String RENDERER = "renderer";
    private int rowHight = 25;
    private Renderer renderer = new Renderer();
    private FootRenderer footRenderer = new FootRenderer();
    private DatasetField dsField = new DatasetField();

    public int getRowHight() {
        return this.rowHight;
    }

    public void setRowHight(int rowHight) {
        this.rowHight = rowHight;
    }

    public GridColumn() {
        this.setCol(999);
        this.setRow(1);
        this.headHight = 25;
        this.setSize(100, this.rowHight * 2 + 10);
        this.setComponentType(GRIDCOLUMN);
        this.setPrompt("prompt");
        this.setEditor(editors[0]);
        Renderer r = new Renderer();
        this.setRenderer(r);
        FootRenderer fr = new FootRenderer();
        this.setFootRenderer(fr);
    }

    public void addCol(GridColumn col) {
        this.addChild(col);
    }

    @Override
    public boolean isResponsibleChild(AuroraComponent child) {
        return child.getClass().equals(GridColumn.class);
    }

    public void setRenderer(Renderer r) {
        this.renderer = r;
        r.setColumn(this);
        this.firePropertyChange(RENDERER, null, r);
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public void setFootRenderer(FootRenderer r) {
        this.footRenderer = r;
        r.setColumn(this);
        this.firePropertyChange("footerRenderer", null, r);
        r.setColumn(this);
    }

    public FootRenderer getFootRenderer() {
        return this.footRenderer;
    }

    public String getEditor() {
        return this.getStringPropertyValue(EDITOR);
    }

    public void setEditor(String editor) {
        this.setPropertyValue(EDITOR, editor);
    }

    public void setHeadHight(int h) {
        this.headHight = h;
    }

    @Override
    public DatasetField getDatasetField() {
        return this.dsField;
    }

    public void setReadOnly(boolean readOnly) {
        this.dsField.setReadOnly(readOnly);
    }

    public void setRequired(boolean required) {
        this.dsField.setRequired(required);
    }

    @Override
    public void setParent(Container part) {
        super.setParent(part);
    }

    @Override
    public void setDatasetField(DatasetField field) {
        this.dsField = field;
        this.dsField.setName(this.getName());
    }

    @Override
    public Object getPropertyValue(String propId) {
        if ("footerRenderer".equals(propId)) {
            return this.getFootRenderer();
        }
        if (RENDERER.equals(propId)) {
            return this.getRenderer();
        }
        if ("i_dataset_field_delegate".equals(propId)) {
            return this.dsField;
        }
        return super.getPropertyValue(propId);
    }

    @Override
    public void setPropertyValue(String propId, Object val) {
        if (RENDERER.equals(propId) && val instanceof Renderer) {
            this.setRenderer((Renderer)val);
            return;
        }
        if ("footerRenderer".equals(propId) && val instanceof FootRenderer) {
            this.setFootRenderer((FootRenderer)val);
            return;
        }
        if ("i_dataset_field_delegate".equals(propId) && val instanceof DatasetField) {
            this.setDatasetField((DatasetField)val);
            return;
        }
        super.setPropertyValue(propId, val);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        super.addPropertyChangeListener(l);
        if (this.dsField != null) {
            this.dsField.addPropertyChangeListener(l);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        super.removePropertyChangeListener(l);
        if (this.dsField != null) {
            this.dsField.removePropertyChangeListener(l);
        }
    }
}

