/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.source.gen.screen.model;

import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.Container;
import aurora.plugin.source.gen.screen.model.TabBody;
import aurora.plugin.source.gen.screen.model.TabItem;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

public class TabFolder
extends Container {
    public static final String TAB_PANEL = "tabPanel";

    public TabFolder() {
        this.setSize(800, 420);
        this.setComponentType(TAB_PANEL);
        this.addPropertyChangeListener(new TabItemOperationListener());
    }

    public void disSelectAll() {
        for (AuroraComponent ac : this.getChildren()) {
            if (!(ac instanceof TabItem)) break;
            ((TabItem)ac).setCurrent(false);
        }
    }

    public ArrayList<TabItem> getTabItems() {
        ArrayList<TabItem> als = new ArrayList<TabItem>(this.children.size() / 2);
        int i = 0;
        while (i < this.children.size() / 2) {
            als.add((TabItem)this.children.get(i));
            ++i;
        }
        return als;
    }

    public TabItem getCurrent() {
        for (AuroraComponent ac : this.getChildren()) {
            if (!(ac instanceof TabItem) || !((TabItem)ac).isCurrent()) continue;
            return (TabItem)ac;
        }
        return null;
    }

    @Override
    public Object getPropertyValue(String propId) {
        if ("component_tabs".equals(propId)) {
            return this.getTabItems();
        }
        return super.getPropertyValue(propId);
    }

    @Override
    public void setPropertyValue(String propId, Object val) {
        if ("component_tabs".equals(propId) && val instanceof List) {
            super.setPropertyValue("component_children", val);
        }
        super.setPropertyValue(propId, val);
    }

    @Override
    public boolean isResponsibleChild(AuroraComponent component) {
        Class<?> cls = component.getClass();
        return cls.equals(TabItem.class) || cls.equals(TabBody.class);
    }

    private class TabItemOperationListener
    implements PropertyChangeListener {
        private TabItemOperationListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!"component_children".equals(evt.getPropertyName())) {
                return;
            }
            Object obj = evt.getNewValue();
            if (!(obj instanceof TabItem)) {
                return;
            }
            TabItem ti = (TabItem)obj;
            TabBody body = ti.getBody();
            List<AuroraComponent> list = TabFolder.this.getChildren();
            int idx = list.indexOf(ti);
            TabFolder.this.disSelectAll();
            if (idx == -1) {
                idx = list.indexOf(body);
                TabFolder.this.removeChild(body);
                if (ti.isCurrent()) {
                    if ((idx -= list.size() / 2) < list.size() / 2) {
                        ((TabItem)list.get(idx)).setCurrent(true);
                    } else if (idx > 0) {
                        ((TabItem)list.get(idx - 1)).setCurrent(true);
                    }
                }
                return;
            }
            if (idx > list.size() / 2) {
                list.remove(ti);
                idx = list.size() / 2;
                TabFolder.this.addChild(ti, idx);
                return;
            }
            TabFolder.this.addChild(body, idx + 1 + list.size() / 2);
            ti.setCurrent(true);
        }
    }
}

