/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.spnego;

import aurora.plugin.spnego.Base64;

public class SpnegoAuthScheme {
    private static final transient byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final transient String scheme;
    private final transient String token;
    private final transient boolean basicScheme;
    private final transient boolean negotiateScheme;
    private final transient boolean ntlm;

    public SpnegoAuthScheme(String authScheme, String authToken) {
        this.scheme = authScheme;
        this.token = authToken;
        this.ntlm = authToken == null || authToken.isEmpty() ? false : authToken.startsWith("TlRMTVNT");
        this.negotiateScheme = "Negotiate".equalsIgnoreCase(authScheme);
        this.basicScheme = "Basic".equalsIgnoreCase(authScheme);
    }

    boolean isBasicScheme() {
        return this.basicScheme;
    }

    boolean isNegotiateScheme() {
        return this.negotiateScheme;
    }

    boolean isNtlmToken() {
        return this.ntlm;
    }

    public String getScheme() {
        return this.scheme;
    }

    public byte[] getToken() {
        return this.token == null ? EMPTY_BYTE_ARRAY : Base64.decode(this.token);
    }
}

