/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.spnego;

import aurora.plugin.spnego.SpnegoAuthScheme;
import aurora.plugin.spnego.SpnegoHttpServletResponse;
import java.io.IOException;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.servlet.http.HttpServletRequest;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class SpnegoProvider {
    static final GSSManager MANAGER = GSSManager.getInstance();
    static final Oid SPNEGO_OID = SpnegoProvider.getOid();

    private SpnegoProvider() {
    }

    static SpnegoAuthScheme negotiate(HttpServletRequest req, SpnegoHttpServletResponse resp, boolean basicSupported, boolean promptIfNtlm, String realm) throws IOException {
        SpnegoAuthScheme scheme = SpnegoProvider.getAuthScheme(req.getHeader("Authorization"));
        if (scheme == null || scheme.getToken().length == 0) {
            resp.setHeader("WWW-Authenticate", "Negotiate");
            if (basicSupported) {
                resp.addHeader("WWW-Authenticate", "Basic realm=\"" + realm + '\"');
            }
            resp.setStatus(401, true);
            return null;
        }
        if (scheme.isNtlmToken()) {
            if (resp.isStatusSet()) {
                throw new IllegalStateException("HTTP Status already set.");
            }
            if (!basicSupported || !promptIfNtlm) {
                throw new UnsupportedOperationException("NTLM specified. Downgraded to Basic Auth (and/or SSL) but downgrade not supported.");
            }
            resp.setHeader("WWW-Authenticate", "Basic realm=\"" + realm + '\"');
            resp.setStatus(401, true);
            return null;
        }
        return scheme;
    }

    public static GSSCredential getClientCredential(Subject subject) throws PrivilegedActionException {
        PrivilegedExceptionAction<GSSCredential> action = new PrivilegedExceptionAction<GSSCredential>(){

            @Override
            public GSSCredential run() throws GSSException {
                return MANAGER.createCredential(null, 0, SPNEGO_OID, 1);
            }
        };
        return Subject.doAs(subject, action);
    }

    public static GSSContext getGSSContext(GSSCredential creds, URL url) throws GSSException {
        return MANAGER.createContext(SpnegoProvider.getServerName(url), SPNEGO_OID, creds, 0);
    }

    public static SpnegoAuthScheme getAuthScheme(String header) {
        if (header == null || header.isEmpty()) {
            return null;
        }
        if (header.startsWith("Negotiate")) {
            String token = header.substring("Negotiate".length() + 1);
            return new SpnegoAuthScheme("Negotiate", token);
        }
        if (header.startsWith("Basic")) {
            String token = header.substring("Basic".length() + 1);
            return new SpnegoAuthScheme("Basic", token);
        }
        throw new UnsupportedOperationException("Negotiate or Basic Only:" + header);
    }

    private static Oid getOid() {
        Oid oid = null;
        try {
            oid = new Oid("1.3.6.1.5.5.2");
        }
        catch (GSSException gSSException) {
            // empty catch block
        }
        return oid;
    }

    static GSSCredential getServerCredential(Subject subject) throws PrivilegedActionException {
        PrivilegedExceptionAction<GSSCredential> action = new PrivilegedExceptionAction<GSSCredential>(){

            @Override
            public GSSCredential run() throws GSSException {
                return MANAGER.createCredential(null, Integer.MAX_VALUE, SPNEGO_OID, 2);
            }
        };
        return Subject.doAs(subject, action);
    }

    static GSSName getServerName(URL url) throws GSSException {
        return MANAGER.createName("HTTP@" + url.getHost(), GSSName.NT_HOSTBASED_SERVICE, SPNEGO_OID);
    }

    public static CallbackHandler getUsernamePasswordHandler(final String username, final String password) {
        CallbackHandler handler = new CallbackHandler(){

            @Override
            public void handle(Callback[] callback) {
                int i = 0;
                while (i < callback.length) {
                    if (callback[i] instanceof NameCallback) {
                        NameCallback nameCallback = (NameCallback)callback[i];
                        nameCallback.setName(username);
                    } else if (callback[i] instanceof PasswordCallback) {
                        PasswordCallback passCallback = (PasswordCallback)callback[i];
                        passCallback.setPassword(password.toCharArray());
                    }
                    ++i;
                }
            }
        };
        return handler;
    }
}

