/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sync.cvs;

import aurora.plugin.quartz.AuroraJobDetail;
import aurora.plugin.quartz.SchedulerConfig;
import aurora.plugin.sync.cvs.CVSClient;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.log.RlogCommand;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.CVSAdapter;
import org.netbeans.lib.cvsclient.event.CVSListener;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import org.quartz.JobExecutionContext;
import uncertain.composite.CompositeMap;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;

public class CVSHistorySync
extends CVSAdapter {
    String connectionString;
    String timezone = "PST";
    String dataSourceName;
    String jobName;
    IObjectRegistry registry = SchedulerConfig.getObjectRegistry();
    ILogger mLogger = LoggingContext.getLogger((String)"aurora.plugin.cvs.sync", (IObjectRegistry)this.registry);
    StringBuffer comments;
    Connection conn;
    boolean is_success = true;
    boolean debug = false;
    static final String TIME_ZONE_KEY = "timezone";
    static final String DATASOURCE_NAME_KEY = "datasourcename";
    String headFrom;
    String headTo;
    String fileName;
    CompositeMap dataMap;
    Map<String, String> tagMap;
    CompositeMap rowMap;
    boolean is_begin = false;
    final String queryHistorySql = "select t.file_name,t.head,t.old_head from sys_cvs_file_temp t";
    final String saveSql = "sys_cvs_sync_pkg.save_sync_history(?,?,?,?,?,?,?,?,?,?)";

    public void execute(JobExecutionContext context) throws Exception {
        AuroraJobDetail detail = (AuroraJobDetail)context.getJobDetail();
        CompositeMap config = detail.getConfig();
        this.jobName = config.getString((Object)"name");
        this.dataSourceName = config.getString((Object)DATASOURCE_NAME_KEY);
        this.timezone = config.getString((Object)TIME_ZONE_KEY);
        this.debug = config.getBoolean((Object)"debug", false);
        this.processSync();
    }

    /*
     * Exception decompiling
     */
    public void processSync() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void syncHistory() throws SQLException, AuthenticationException, IOException, CommandException {
        Statement stmt = null;
        ResultSet resultSet = null;
        try {
            stmt = this.conn.createStatement();
            resultSet = stmt.executeQuery("select t.file_name,t.head,t.old_head from sys_cvs_file_temp t");
            while (resultSet.next()) {
                this.fileName = resultSet.getString(1);
                this.headTo = resultSet.getString(2);
                this.headFrom = resultSet.getString(3);
                if (this.headFrom == null) {
                    this.headFrom = "";
                }
                this.dataMap = new CompositeMap();
                this.tagMap = new HashMap<String, String>();
                this.executeHistoryCommand();
                this.processSyncHistory();
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    void executeHistoryCommand() throws AuthenticationException, IOException, CommandException {
        CVSClient cvsclient = new CVSClient(this.connectionString);
        cvsclient.addCVSListener((CVSListener)this);
        try {
            cvsclient.openConnection();
            RlogCommand command = new RlogCommand();
            command.setModule(this.fileName);
            command.setRevisionFilter(String.valueOf(this.headFrom) + ":" + this.headTo);
            cvsclient.excute((Command)command);
        }
        finally {
            cvsclient.closeConnection();
        }
    }

    public void messageSent(MessageEvent event) {
        this.is_success = !event.isError();
        String line = event.getMessage();
        PrintStream stream = event.isError() ? System.err : System.out;
        StringBuffer taggedLine = new StringBuffer();
        if (event.isTagged()) {
            String message = MessageEvent.parseTaggedMessage((StringBuffer)taggedLine, (String)"Daniel Six");
            if (message != null) {
                stream.println(message);
            }
        } else {
            if (this.debug) {
                stream.println(line);
            }
            this.dataConvert(line);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void processSyncHistory() throws SQLException {
        Statement cstm = null;
        try {
            block9: {
                Iterator it;
                block8: {
                    it = this.dataMap.getChildIterator();
                    if (it == null) {
                        System.out.println(this.dataMap.toXML());
                    }
                    cstm = this.conn.prepareCall("{call sys_cvs_sync_pkg.save_sync_history(?,?,?,?,?,?,?,?,?,?)}");
                    if (!true) break block8;
                    if (it == null) return;
                    if (!it.hasNext()) break block9;
                }
                do {
                    CompositeMap row = (CompositeMap)it.next();
                    String head = row.getString((Object)"revision");
                    String tag = null;
                    if (this.tagMap.containsKey(head)) {
                        tag = this.tagMap.get(head);
                    }
                    cstm.setString(1, this.jobName);
                    cstm.setString(2, this.fileName);
                    cstm.setString(3, row.getString((Object)"author"));
                    cstm.setString(4, head);
                    cstm.setString(5, row.getString((Object)"date"));
                    cstm.setString(6, this.timezone);
                    cstm.setString(7, row.getString((Object)"state"));
                    cstm.setString(8, row.getString((Object)"lines"));
                    cstm.setString(9, tag);
                    cstm.setString(10, row.getString((Object)"comments"));
                    cstm.execute();
                    if (it == null) return;
                } while (it.hasNext());
            }
            return;
        }
        finally {
            if (cstm != null) {
                cstm.close();
            }
        }
    }

    void dataConvert(String line) {
        if (line.startsWith("RCS")) {
            this.is_begin = true;
            this.rowMap = null;
        }
        if (line.startsWith("-----")) {
            if (!this.is_begin) {
                this.rowMap.putString((Object)"comments", this.comments.toString());
            }
            this.rowMap = this.dataMap.createChild("record");
            this.is_begin = false;
            this.comments = new StringBuffer();
            return;
        }
        if (line.startsWith("=====")) {
            this.rowMap.putString((Object)"comments", this.comments.toString());
            return;
        }
        if (this.rowMap != null && this.rowMap.containsKey((Object)"date")) {
            if (this.comments.length() == 0) {
                this.comments.append(line);
            } else {
                this.comments.append("\n");
                this.comments.append(line);
            }
            return;
        }
        if (line.startsWith("revision")) {
            this.rowMap.putString((Object)"revision", line.split(" ")[1].trim());
            return;
        }
        if (line.startsWith("date")) {
            String[] array;
            String[] stringArray = array = line.split(";");
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                String en = stringArray[n2];
                if (en.startsWith("date")) {
                    this.rowMap.putString((Object)"date", en.substring(5).trim());
                } else {
                    this.rowMap.putString((Object)en.split(":")[0].trim(), en.split(":")[1].trim());
                }
                ++n2;
            }
            return;
        }
        if (line.startsWith("symbolic names")) {
            this.dataMap.put((Object)"symbolicNames", (Object)true);
            return;
        }
        if (this.dataMap.containsKey((Object)"symbolicNames") && line.startsWith("\t")) {
            int index = line.lastIndexOf(":");
            String key = line.substring(index + 1).trim();
            String value = line.substring(0, index).trim();
            if (!this.tagMap.containsKey(key)) {
                this.tagMap.put(key, value);
            } else {
                String tag = this.tagMap.get(key);
                tag = String.valueOf(tag) + "," + value;
                this.tagMap.put(key, tag);
            }
            return;
        }
    }
}

