/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features;

import aurora.application.config.ScreenConfig;
import aurora.bm.BusinessModel;
import aurora.bm.Field;
import aurora.bm.IModelFactory;
import aurora.database.actions.config.ActionConfigManager;
import aurora.database.actions.config.ModelQueryConfig;
import aurora.events.E_PrepareServiceConfig;
import aurora.presentation.BuildSession;
import aurora.presentation.IViewBuilder;
import aurora.presentation.ViewContext;
import aurora.presentation.ViewCreationException;
import aurora.presentation.component.std.IDGenerator;
import aurora.presentation.component.std.config.DataSetConfig;
import aurora.presentation.component.std.config.DataSetFieldConfig;
import aurora.service.IService;
import aurora.service.ServiceContext;
import aurora.service.ServiceInstance;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;

public class DataSetInit
implements IViewBuilder,
E_PrepareServiceConfig {
    IModelFactory mFactory;

    public DataSetInit(IModelFactory factory) {
        this.mFactory = factory;
    }

    @Override
    public int onPrepareServiceConfig(IService service) throws Exception {
        ServiceContext sc = service.getServiceContext();
        CompositeMap model = sc.getModel();
        ServiceInstance svc = (ServiceInstance)service;
        CompositeMap screen_config_map = svc.getServiceConfigData();
        if (!"screen".equals(screen_config_map.getName())) {
            return 0;
        }
        ScreenConfig screen = ScreenConfig.createScreenConfig(screen_config_map);
        CompositeMap datasets = screen.getDataSetsConfig();
        if (datasets == null) {
            return 0;
        }
        List list = datasets.getChildsNotNull();
        ArrayList dslist = new ArrayList();
        for (CompositeMap dataset : list) {
            this.processDataSet(dataset, model, dslist, screen);
        }
        datasets.getChilds().addAll(dslist);
        return 0;
    }

    private void processDataSet(CompositeMap ds, CompositeMap model, List dslist, ScreenConfig screen) throws Exception {
        DataSetConfig dsc = DataSetConfig.getInstance(ds);
        String queryUrl = dsc.getQueryUrl();
        String submitUrl = dsc.getSubmitUrl();
        String baseModel = dsc.getModel();
        boolean cq = dsc.isCanQuery();
        boolean cs = dsc.isCanSubmit();
        if (baseModel != null) {
            int pi = (baseModel = TextParser.parse(baseModel, model)).indexOf("?");
            if (pi != -1) {
                String pstr = baseModel.substring(pi + 1, baseModel.length());
                baseModel = baseModel.substring(0, pi);
            }
            if (dsc.getLoadData()) {
                String id = dsc.getId();
                id = TextParser.parse(id, model);
                ModelQueryConfig mqc = ActionConfigManager.createModelQuery();
                mqc.setModel(baseModel);
                mqc.setRootPath("/model/" + id == null ? baseModel : id);
                mqc.setAutoCount(false);
                mqc.setFetchAll(true);
                screen.addInitProcedureAction(mqc.getObjectContext());
                CompositeMap datas = ds.getChild("datas");
                if (datas == null) {
                    datas = ds.createChild("datas");
                }
                datas.putString("datasource", "/model/" + id == null ? baseModel : id);
            }
            if (cq && "".equals(queryUrl)) {
                ds.putString("queryurl", String.valueOf(model.getObject("/request/@context_path").toString()) + "/autocrud/" + baseModel + "/query");
            }
            if (cs && "".equals(submitUrl)) {
                ds.putString("submiturl", String.valueOf(model.getObject("/request/@context_path").toString()) + "/autocrud/" + baseModel + "/batch_update");
            }
            BusinessModel bm = null;
            bm = this.mFactory.getModelForRead(baseModel);
            Field[] bmfields = bm.getFields();
            if (bmfields != null) {
                CompositeMap fields = ds.getChild("fields");
                if (fields == null) {
                    fields = new CompositeMap("fields");
                    ds.addChild(fields);
                }
                ArrayList<CompositeMap> childs = new ArrayList<CompositeMap>();
                List list = fields.getChildsNotNull();
                int fl = bmfields.length;
                int n = 0;
                while (n < fl) {
                    Field field = bmfields[n];
                    this.processField(model, field, dslist);
                    DataSetFieldConfig fieldConfig = DataSetFieldConfig.getInstance(field.getObjectContext());
                    for (CompositeMap lfield : list) {
                        if (!field.getString("name").equalsIgnoreCase(lfield.getString("name"))) continue;
                        fieldConfig.getObjectContext().copy(lfield);
                        if (fieldConfig.getPrompt() != null) continue;
                        fieldConfig.setPrompt(bm.getFieldPrompt(field));
                    }
                    childs.add(fieldConfig.getObjectContext());
                    ++n;
                }
                for (CompositeMap lfield : list) {
                    boolean has = false;
                    int n2 = 0;
                    while (n2 < fl) {
                        Field field = bmfields[n2];
                        if (field.getString("name").equalsIgnoreCase(lfield.getString("name"))) {
                            has = true;
                            break;
                        }
                        ++n2;
                    }
                    if (has) continue;
                    childs.add(lfield);
                }
                fields.getChilds().clear();
                fields.getChilds().addAll(childs);
            }
        }
    }

    private void processField(CompositeMap model, Field field, List list) {
        String sourceModel;
        String type = field.getEditorType();
        if ("combobox".equalsIgnoreCase(type) && !"".equals(sourceModel = field.getObjectContext().getString("sourcemodel", ""))) {
            String id = IDGenerator.getInstance().generate();
            DataSetConfig ds = DataSetConfig.getInstance();
            ds.setModel(sourceModel);
            ds.setFetchAll(true);
            ds.setQueryUrl(String.valueOf(model.getObject("/request/@context_path").toString()) + "/autocrud/" + sourceModel + "/query");
            ds.setAutoQuery(true);
            ds.setId(id);
            list.add(ds.getObjectContext());
            field.setOptions(id);
        }
    }

    @Override
    public void buildView(BuildSession session, ViewContext view_context) throws IOException, ViewCreationException {
        try {
            session.buildViews(view_context.getModel(), view_context.getView().getChilds());
        }
        catch (Exception e) {
            throw new ViewCreationException(e);
        }
    }

    @Override
    public String[] getBuildSteps(ViewContext context) {
        return null;
    }
}

