/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features.cstm;

import aurora.application.features.cstm.CustomSourceCode;
import aurora.application.features.cstm.ICustomizationDataProvider;
import aurora.events.E_PrepareServiceConfig;
import aurora.service.IService;
import aurora.service.ServiceContext;
import aurora.service.ServiceInstance;
import uncertain.composite.CompositeMap;
import uncertain.ocm.IObjectRegistry;

public class ConfigCustomizationListener
implements E_PrepareServiceConfig {
    public static final String KEY_CUSTOMIZATION_ENABLED = "customizationenabled";
    ICustomizationDataProvider mCustomizationDataProvider;
    IObjectRegistry registry;

    public ConfigCustomizationListener(IObjectRegistry registry) {
        this.registry = registry;
        this.mCustomizationDataProvider = (ICustomizationDataProvider)registry.getInstanceOfType(ICustomizationDataProvider.class);
    }

    @Override
    public int onPrepareServiceConfig(IService service) throws Exception {
        ServiceInstance svc = (ServiceInstance)service;
        CompositeMap config = svc.getServiceConfigData();
        boolean customization_enabled = config.getBoolean(KEY_CUSTOMIZATION_ENABLED, this.mCustomizationDataProvider.getDefaultCustomizationEnabled());
        if (customization_enabled) {
            ServiceContext svc_context = svc.getServiceContext();
            String svc_name = svc.getName();
            CompositeMap data = this.mCustomizationDataProvider.getCustomizationData(svc_name, svc_context.getObjectContext());
            if (data != null) {
                CustomSourceCode.custom(this.registry, config, data);
            }
        }
        return 0;
    }
}

