/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.task;

import aurora.application.task.TaskHandler;
import aurora.application.task.TaskUtil;
import java.sql.Connection;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import uncertain.composite.CompositeMap;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;

public class TaskFetcher
implements Callable<String> {
    private IObjectRegistry mRegistry;
    private TaskHandler taskManager;
    private Connection connection;
    private ILogger logger;
    private TaskUtil taskUtil;
    private int failedTime = 0;
    private int retryTime = 10;

    public TaskFetcher(IObjectRegistry registry, TaskHandler taskManager) {
        this.mRegistry = registry;
        this.taskManager = taskManager;
        this.logger = LoggingContext.getLogger(this.getClass().getCanonicalName(), this.mRegistry);
        this.taskUtil = new TaskUtil(this.logger, this.mRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String call() throws Exception {
        block22: {
            try {
                boolean hasNext = false;
                this.connection = this.taskManager.getConnection();
                while (this.taskManager.isRunnning()) {
                    Object object = this.taskManager.fetchNewTaskLock;
                    synchronized (object) {
                        block21: {
                            if (!hasNext) {
                                int fetchTaskTimerInterval = this.taskManager.getFetchTaskTimerInterval();
                                if (fetchTaskTimerInterval > 0) {
                                    this.taskManager.fetchNewTaskLock.wait(fetchTaskTimerInterval);
                                } else {
                                    this.taskManager.fetchNewTaskLock.wait();
                                }
                            }
                            if (!this.taskManager.isRunnning()) {
                                break;
                            }
                            CompositeMap task = new CompositeMap();
                            CompositeMap context = new CompositeMap();
                            try {
                                int record_count;
                                this.taskUtil.executeBM(this.connection, this.taskManager.getFetchTaskBM(), context, task);
                                if (this.failedTime > 0) {
                                    this.failedTime = 0;
                                }
                                if (task == null || this.taskUtil.getTaskId(task) == -1) {
                                    continue;
                                }
                                this.logger.log(Level.CONFIG, "add record to queue,task_id=" + this.taskUtil.getTaskId(task));
                                this.taskManager.addToTaskQueue(task);
                                hasNext = false;
                                if (!this.taskManager.hasIdleConnnection() || (record_count = task.getInt("record_count", -1)) <= 1) break block21;
                                hasNext = true;
                            }
                            catch (Exception e) {
                                this.logger.log(Level.SEVERE, "", e);
                                ++this.failedTime;
                                if (this.failedTime < this.retryTime) {
                                    this.taskUtil.closeConnection(this.connection);
                                    this.connection = this.taskManager.getConnection();
                                    this.logger.log(Level.SEVERE, "It has failed " + this.failedTime + " time when get task from database,please check the configuration!");
                                    continue;
                                }
                                this.logger.log(Level.SEVERE, "It has failed " + this.failedTime + " time when get task from database! It will quit now.");
                                break;
                            }
                        }
                    }
                }
            }
            catch (InterruptedException hasNext) {
                this.taskUtil.closeConnection(this.connection);
                break block22;
            }
            catch (Exception e) {
                try {
                    this.logger.log(Level.SEVERE, "", e);
                    break block22;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.taskUtil.closeConnection(this.connection);
                }
            }
            this.taskUtil.closeConnection(this.connection);
        }
        this.logger.log(Level.CONFIG, "taskFetcher finished.");
        return "finished";
    }
}

