/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.task;

import aurora.application.features.msg.IConsumer;
import aurora.application.features.msg.IMessage;
import aurora.application.features.msg.IMessageListener;
import aurora.application.features.msg.IMessageStub;
import aurora.application.features.msg.INoticerConsumer;
import aurora.application.features.msg.Message;
import aurora.application.task.TaskExecutorManager;
import aurora.application.task.TaskFetcher;
import aurora.application.task.TaskUtil;
import aurora.database.service.IDatabaseServiceFactory;
import aurora.service.IServiceFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import javax.sql.DataSource;
import uncertain.composite.CompositeMap;
import uncertain.core.ILifeCycle;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.IProcedureManager;

public class TaskHandler
extends AbstractLocatableObject
implements ILifeCycle,
IMessageListener {
    public static final String DEFAULT_TOPIC = "task";
    public static final String DEFAULT_MESSAGE = "task_message";
    public static final String NEW_MESSAGE = "new_task_message";
    public static final String REMOVE_MESSAGE = "remove_task_message";
    private IObjectRegistry mRegistry;
    private String oldTaskBM;
    private String fetchTaskBM;
    private String updateTaskBM;
    private String finishTaskBM;
    private int threadCount = 2;
    private int fetchTaskTimerInterval = 10000;
    private IDatabaseServiceFactory databaseServiceFactory;
    private DataSource dataSource;
    private IProcedureManager procedureManager;
    private IServiceFactory serviceFactory;
    private IMessageStub msgStub;
    private ILogger logger;
    private boolean running = true;
    private Queue<CompositeMap> taskQueue = new ConcurrentLinkedQueue<CompositeMap>();
    private ExecutorService mainThreadPool;
    private TaskExecutorManager taskExecutorManager;
    protected String topic = "task";
    protected String new_message = "new_task_message";
    protected String remove_message = "remove_task_message";
    private Queue<Connection> connectionQueue = new ConcurrentLinkedQueue<Connection>();
    private Map<String, Future<String>> runningTask = new HashMap<String, Future<String>>();
    private Map<String, CompositeMap> waitTasks = new HashMap<String, CompositeMap>();
    Object fetchNewTaskLock = new Object();
    private TaskUtil taskUtil;

    public TaskHandler(IObjectRegistry registry) {
        this.mRegistry = registry;
    }

    public void onInitialize() {
        this.initInstances();
        this.initConnectionQueue();
        this.taskUtil = new TaskUtil(this.logger, this.mRegistry);
        TaskFetcher taskFetcher = new TaskFetcher(this.mRegistry, this);
        this.taskExecutorManager = new TaskExecutorManager(this.mRegistry, this);
        this.mainThreadPool = Executors.newFixedThreadPool(2);
        this.mainThreadPool.submit(taskFetcher);
        this.mainThreadPool.submit(this.taskExecutorManager);
        this.resetUnfinishedTaskStatus(this.msgStub);
    }

    private void initConnectionQueue() {
        int i = 0;
        while (i < this.threadCount) {
            this.connectionQueue.add(this.getConnection());
            ++i;
        }
    }

    private void initInstances() {
        IConsumer consumer;
        this.logger = LoggingContext.getLogger(this.getClass().getCanonicalName(), this.mRegistry);
        if (this.fetchTaskBM == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "fetchTaskBM");
        }
        if (this.updateTaskBM == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "updateTaskBM");
        }
        if (this.finishTaskBM == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "finishTaskBM");
        }
        this.dataSource = (DataSource)this.mRegistry.getInstanceOfType(DataSource.class);
        if (this.dataSource == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, DataSource.class, this.getClass().getName());
        }
        this.databaseServiceFactory = (IDatabaseServiceFactory)this.mRegistry.getInstanceOfType(IDatabaseServiceFactory.class);
        if (this.databaseServiceFactory == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, IDatabaseServiceFactory.class, this.getClass().getName());
        }
        this.procedureManager = (IProcedureManager)this.mRegistry.getInstanceOfType(IProcedureManager.class);
        if (this.procedureManager == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, IProcedureManager.class, this.getClass().getName());
        }
        this.serviceFactory = (IServiceFactory)this.mRegistry.getInstanceOfType(IServiceFactory.class);
        if (this.serviceFactory == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, IServiceFactory.class, this.getClass().getName());
        }
        this.msgStub = (IMessageStub)this.mRegistry.getInstanceOfType(IMessageStub.class);
        if (this.msgStub == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, IMessageStub.class, this.getClass().getName());
        }
        if (!this.msgStub.isStarted()) {
            this.logger.warning("JMS MessageStub is not started, please check the configuration.");
        }
        if ((consumer = this.msgStub.getConsumer(this.topic)) == null) {
            throw new IllegalStateException("MessageStub does not define the topic '" + this.topic + "', please check the configuration.");
        }
        if (!(consumer instanceof INoticerConsumer)) {
            throw BuiltinExceptionFactory.createInstanceTypeWrongException(this.getOriginSource(), INoticerConsumer.class, IConsumer.class);
        }
        ((INoticerConsumer)consumer).addListener(DEFAULT_MESSAGE, this);
        ((INoticerConsumer)consumer).addListener(this.new_message, this);
        ((INoticerConsumer)consumer).addListener(this.remove_message, this);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    TaskHandler.this.shutdown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void resetUnfinishedTaskStatus(IMessageStub messageStub) {
        Connection connection = this.getConnection();
        if (this.oldTaskBM != null) {
            try {
                try {
                    CompositeMap context = new CompositeMap("context");
                    CompositeMap parameter = new CompositeMap("parameter");
                    this.taskUtil.executeBM(connection, this.oldTaskBM, context, parameter);
                    Message msg = new Message(this.new_message, null);
                    messageStub.getDispatcher().send(this.topic, msg, context);
                    context.clear();
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, "", e);
                    this.taskUtil.closeConnection(connection);
                }
            }
            finally {
                this.taskUtil.closeConnection(connection);
            }
        }
    }

    public boolean isRunnning() {
        return this.running;
    }

    public String getOldTaskBM() {
        return this.oldTaskBM;
    }

    public void setOldTaskBM(String oldTaskBM) {
        this.oldTaskBM = oldTaskBM;
    }

    public String getFetchTaskBM() {
        return this.fetchTaskBM;
    }

    public void setFetchTaskBM(String fetchTaskBM) {
        this.fetchTaskBM = fetchTaskBM;
    }

    public String getUpdateTaskBM() {
        return this.updateTaskBM;
    }

    public void setUpdateTaskBM(String updateTaskBM) {
        this.updateTaskBM = updateTaskBM;
    }

    public String getFinishTaskBM() {
        return this.finishTaskBM;
    }

    public void setFinishTaskBM(String finishTaskBM) {
        this.finishTaskBM = finishTaskBM;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public int getFetchTaskTimerInterval() {
        return this.fetchTaskTimerInterval;
    }

    public void setFetchTaskTimerInterval(int fetchTaskTimerInterval) {
        this.fetchTaskTimerInterval = fetchTaskTimerInterval;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getMessage() {
        return this.new_message;
    }

    public void setMessage(String message) {
        this.new_message = message;
    }

    public Connection getConnection() {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        if (connection == null) {
            throw new IllegalStateException("Can't get database connection from dataSource.");
        }
        return connection;
    }

    @Override
    public boolean startup() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.running = false;
        Object object = this.fetchNewTaskLock;
        synchronized (object) {
            this.fetchNewTaskLock.notify();
        }
        try {
            this.taskExecutorManager.shutdown();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "", e);
        }
        if (this.mainThreadPool != null) {
            List<Runnable> taskList = this.mainThreadPool.shutdownNow();
            for (Runnable task : taskList) {
                if (task instanceof ILifeCycle) {
                    ((ILifeCycle)((Object)task)).shutdown();
                    continue;
                }
                this.logger.log(Level.SEVERE, "Task " + task.toString() + " can not shutdown!");
            }
        }
        if (this.connectionQueue != null) {
            Connection connection = this.connectionQueue.poll();
            while (connection != null) {
                this.taskUtil.closeConnection(connection);
                connection = this.connectionQueue.poll();
            }
        }
        if (this.runningTask != null) {
            this.runningTask.clear();
        }
    }

    public void addRunningTask(String taskId, Future<String> task) {
        this.runningTask.put(taskId, task);
    }

    public void stopRunningTask(String taskId) {
        Future<String> task = this.runningTask.get(taskId);
        if (task != null) {
            task.cancel(true);
        }
        this.removeRunningTask(taskId);
    }

    public void cancelTask(String taskId) {
        CompositeMap task = this.waitTasks.get(taskId);
        if (task != null) {
            this.taskQueue.remove(task);
        }
        this.stopRunningTask(taskId);
    }

    public void removeRunningTask(String taskId) {
        this.runningTask.remove(taskId);
    }

    public void addToTaskQueue(CompositeMap task) {
        if (task == null) {
            return;
        }
        this.taskQueue.add(task);
        this.waitTasks.put(String.valueOf(this.taskUtil.getTaskId(task)), task);
    }

    public CompositeMap popTaskQueue() {
        CompositeMap task = this.taskQueue.poll();
        if (task != null) {
            String taskId = String.valueOf(this.taskUtil.getTaskId(task));
            this.waitTasks.remove(taskId);
        }
        return task;
    }

    public boolean hasIdleConnnection() {
        return this.connectionQueue.size() > 0;
    }

    public Connection getConnectionFromQueue() {
        return this.connectionQueue.poll();
    }

    public void backToQueue(Connection connection) {
        this.connectionQueue.add(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkTaskQueue() {
        if (this.taskQueue.size() == 0) {
            Object object = this.fetchNewTaskLock;
            synchronized (object) {
                this.fetchNewTaskLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(IMessage message) {
        block8: {
            try {
                String taskId;
                String taskType = message.getText();
                if (this.new_message.equalsIgnoreCase(taskType) || DEFAULT_MESSAGE.equalsIgnoreCase(taskType)) {
                    if (this.taskQueue.size() > 0) {
                        return;
                    }
                    this.logger.log(Level.CONFIG, "receive a messsage:" + message.getText());
                    Object object = this.fetchNewTaskLock;
                    synchronized (object) {
                        this.fetchNewTaskLock.notify();
                        break block8;
                    }
                }
                if (this.remove_message.equals(taskType) && (taskId = message.getProperties().getString("task_id")) != null) {
                    this.cancelTask(taskId);
                }
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Can not add the task:" + message);
            }
        }
    }
}

