/*
 * Decompiled with CFR 0.152.
 */
package aurora.bm;

import aurora.bm.BusinessModel;
import aurora.bm.Field;
import aurora.bm.ICachedDataProvider;
import aurora.bm.Reference;
import aurora.bm.Relation;
import aurora.bm.RelationFields;
import aurora.database.IResultSetConsumer;
import aurora.database.service.DatabaseServiceFactory;
import aurora.database.service.IDatabaseServiceFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import uncertain.cache.CacheBuiltinExceptionFactory;
import uncertain.cache.ICache;
import uncertain.cache.INamedCacheFactory;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.core.ILifeCycle;
import uncertain.ocm.IObjectRegistry;

public class BmCachedJoin
implements ILifeCycle {
    IObjectRegistry mRegistry;
    ICachedDataProvider cacheDataProvider;
    IDatabaseServiceFactory dbServiceFactory;

    public BmCachedJoin(IObjectRegistry objectRegistry, ICachedDataProvider cacheDataProvider, IDatabaseServiceFactory dbs) {
        this.mRegistry = objectRegistry;
        this.cacheDataProvider = cacheDataProvider;
        this.dbServiceFactory = dbs;
    }

    @Override
    public boolean startup() {
        if (this.dbServiceFactory instanceof DatabaseServiceFactory) {
            ((DatabaseServiceFactory)this.dbServiceFactory).setGlobalParticipant(this);
        }
        return true;
    }

    @Override
    public void shutdown() {
    }

    public void postFetchResultSet(BusinessModel model, IResultSetConsumer consumer) throws Exception {
        List<RelationFields> cacheJoinList = model.getCacheJoinList();
        if (cacheJoinList == null || cacheJoinList.size() == 0) {
            return;
        }
        Object result = consumer.getResult();
        if (!(result instanceof CompositeMap)) {
            return;
        }
        CompositeMap data = (CompositeMap)result;
        if (data.getChilds() == null) {
            return;
        }
        INamedCacheFactory nameCacheFactory = (INamedCacheFactory)this.mRegistry.getInstanceOfType(INamedCacheFactory.class);
        String lookup_key = null;
        Relation relation = null;
        ICache cache = null;
        CompositeMap cachedRecord = null;
        HashMap<String, CompositeMap> selectedCache = new HashMap<String, CompositeMap>();
        Iterator it = data.getChildIterator();
        while (it.hasNext()) {
            CompositeMap record = (CompositeMap)it.next();
            for (RelationFields relationField : cacheJoinList) {
                relation = relationField.getRelation();
                lookup_key = this.generateLookupCacheKey(relation, record);
                cache = nameCacheFactory.getNamedCache(relation.getReferenceModel());
                if (cache == null) {
                    throw CacheBuiltinExceptionFactory.createNamedCacheNotFound(null, relation.getReferenceModel());
                }
                cachedRecord = this.getCacheValue(cache, selectedCache, lookup_key);
                if (cachedRecord == null) {
                    if (!"INNER JOIN".equalsIgnoreCase(String.valueOf(relation.getJoinType()) + " JOIN")) continue;
                    it.remove();
                    continue;
                }
                for (Field fld : relationField.getFieldSet()) {
                    record.put(fld.getName(), cachedRecord.get(fld.getSourceField()));
                }
            }
        }
        selectedCache.clear();
    }

    private CompositeMap getCacheValue(ICache cache, HashMap<String, CompositeMap> selectedCache, String lookup_key) {
        int max_selectedCache_size = 10000;
        CompositeMap cachedRecord = null;
        cachedRecord = selectedCache.get(lookup_key);
        if (cachedRecord != null) {
            if (cachedRecord.size() == 0) {
                return null;
            }
            return cachedRecord;
        }
        cachedRecord = (CompositeMap)cache.getValue(lookup_key);
        if (selectedCache.size() < max_selectedCache_size) {
            if (cachedRecord != null) {
                selectedCache.put(lookup_key, cachedRecord);
            } else {
                selectedCache.put(lookup_key, new CompositeMap());
            }
        }
        return cachedRecord;
    }

    private String generateLookupCacheKey(Relation relation, CompositeMap record) {
        String recordKey = this.cacheDataProvider.generateKey(this.getRelationCacheLocalFields(relation));
        String lookupCacheKey = String.valueOf(relation.getReferenceModel()) + "." + TextParser.parse(recordKey, record);
        return lookupCacheKey;
    }

    private List<String> getRelationCacheLocalFields(Relation relation) {
        LinkedList<String> localFieldList = new LinkedList<String>();
        Reference[] refs = relation.getReferences();
        if (refs != null) {
            int i = 0;
            while (i < refs.length) {
                Reference ref = refs[i];
                String exp = ref.getExpression();
                if (exp != null) {
                    return null;
                }
                localFieldList.add(ref.getLocalField().toLowerCase());
                ++i;
            }
        }
        return localFieldList;
    }
}

