/*
 * Decompiled with CFR 0.152.
 */
package aurora.bm;

import aurora.bm.AbstractSqlCreator;
import aurora.bm.BusinessModel;
import aurora.bm.Field;
import aurora.bm.IModelFactory;
import aurora.database.profile.IDatabaseFactory;
import aurora.database.service.BusinessModelServiceContext;
import aurora.database.sql.ConditionList;
import aurora.database.sql.DeleteStatement;
import aurora.database.sql.ISqlStatement;
import aurora.database.sql.RawSqlExpression;
import aurora.database.sql.UpdateTarget;

public class DeleteSqlCreator
extends AbstractSqlCreator {
    public void addPrimaryKeyQuery(BusinessModel model, DeleteStatement stmt) {
        ConditionList where = stmt.getWhereClause();
        Field[] fields = model.getPrimaryKeyFields();
        UpdateTarget table = stmt.getUpdateTarget();
        int i = 0;
        while (i < fields.length) {
            where.addEqualExpression(table.createField(fields[i].getPhysicalName()), new RawSqlExpression(fields[i].getUpdateExpression()));
            ++i;
        }
    }

    public DeleteSqlCreator(IModelFactory model_fact, IDatabaseFactory db_fact) {
        super(model_fact, db_fact);
    }

    public DeleteStatement createDeleteStatement(BusinessModel model) {
        DeleteStatement stmt = new DeleteStatement(model.getBaseTable(), model.getAlias());
        return stmt;
    }

    public void onCreateDeleteStatement(BusinessModel model, BusinessModelServiceContext context) {
        DeleteStatement statement = this.createDeleteStatement(model);
        String type = context.getObjectContext().getString("DeleteType", "PK");
        if ("PK".equals(type)) {
            this.addPrimaryKeyQuery(model, statement);
        }
        context.setStatement(statement);
    }

    public void onCreateDeleteSql(ISqlStatement s, BusinessModelServiceContext context) {
        this.doCreateSql("delete", s, context);
    }
}

