/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.sql;

import aurora.database.sql.AbstractStatement;
import aurora.database.sql.CompareExpression;
import aurora.database.sql.Condition;
import aurora.database.sql.ILogicalExpression;
import aurora.database.sql.ISqlStatement;
import aurora.database.sql.RawSqlExpression;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ConditionList
extends AbstractStatement
implements ILogicalExpression {
    public static final String CONDITION_LIST = "CONDITION_LIST";
    List condition_list = new LinkedList();

    public ConditionList() {
        super(CONDITION_LIST);
    }

    public ConditionList(ILogicalExpression[] conditions) {
        this();
        int i = 0;
        while (i < conditions.length) {
            this.addCondition(conditions[i]);
            ++i;
        }
    }

    public void addCondition(Condition condition) {
        condition.setParent(this);
        this.condition_list.add(condition);
    }

    public void addCondition(String operator, ILogicalExpression expression) {
        this.addCondition(new Condition(operator, expression));
    }

    public void addCondition(ILogicalExpression expression) {
        this.addCondition("AND", expression);
    }

    public void addCondition(String raw_expression) {
        this.addCondition(new RawSqlExpression(raw_expression));
    }

    public void addConditions(ILogicalExpression[] expressions) {
        int i = 0;
        while (i < expressions.length) {
            this.addCondition(expressions[i]);
            ++i;
        }
    }

    public void addConditions(Collection condition_list) {
        for (ILogicalExpression exp : condition_list) {
            this.addCondition(exp);
        }
    }

    public void addEqualExpression(ISqlStatement left, ISqlStatement right) {
        CompareExpression comp_exp = new CompareExpression(left, 1, right);
        this.addCondition(comp_exp);
    }

    public boolean removeCondition(Condition c) {
        int index = this.condition_list.indexOf(c);
        if (index < 0) {
            return false;
        }
        ILogicalExpression exp = (ILogicalExpression)this.condition_list.get(index);
        exp.setParent(null);
        this.condition_list.remove(index);
        return true;
    }

    public List getConditions() {
        return Collections.unmodifiableList(this.condition_list);
    }

    public int size() {
        return this.condition_list.size();
    }
}

