/*
 * Decompiled with CFR 0.152.
 */
package aurora.datasource;

import aurora.datasource.DatabaseConnection;
import aurora.datasource.IDataSourceFactory;
import aurora.datasource.nativejdbc.CommonsDbcpNativeJdbcExtractor;
import aurora.datasource.nativejdbc.INativeJdbcExtractor;
import aurora.datasource.nativejdbc.WebLogicNativeJdbcExtractor;
import aurora.datasource.nativejdbc.WebSphereNativeJdbcExtractor;
import java.sql.Connection;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import uncertain.exception.BuiltinExceptionFactory;

public class JNDIDataSourceFactory
implements IDataSourceFactory {
    public static final String WEBLOGIC_CONTAINER_NAME = "WEBLOGIC";
    public static final String TOMCAT_CONTAINER_NAME = "TOMCAT";
    public static final String WAS_CONTAINER_NAME = "WAS";
    public static final String DEFAULT_CONTAINER_NAME = "WEBLOGIC";
    public static final int DEFAULT_LISTENERPORT = 7001;
    private String containerName;

    @Override
    public DataSource createDataSource(DatabaseConnection dbConfig) throws Exception {
        String jndi_name = dbConfig.getJndiName();
        if (jndi_name == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(null, "jndiName");
        }
        this.containerName = dbConfig.getContainerName();
        if (this.containerName == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(null, "containerName");
        }
        return this.createDataSource(jndi_name);
    }

    public DataSource createDataSource(String jndiName) throws NamingException {
        DataSource ds = null;
        InitialContext initCtx = new InitialContext();
        try {
            Context envCtx = (Context)initCtx.lookup("java:comp/env");
            ds = (DataSource)envCtx.lookup(jndiName);
        }
        catch (NamingException e) {
            ds = (DataSource)initCtx.lookup(jndiName);
        }
        return ds;
    }

    @Override
    public void cleanDataSource(DataSource ds) {
    }

    @Override
    public Connection getNativeJdbcExtractor(Connection conn) throws Exception {
        if (conn == null) {
            return null;
        }
        INativeJdbcExtractor nativeJdbcExtractor = null;
        if (this.containerName == null) {
            this.containerName = "WEBLOGIC";
        }
        if (TOMCAT_CONTAINER_NAME.equals(this.containerName)) {
            nativeJdbcExtractor = new CommonsDbcpNativeJdbcExtractor();
        } else if ("WEBLOGIC".equals(this.containerName)) {
            nativeJdbcExtractor = new WebLogicNativeJdbcExtractor();
        } else if (WAS_CONTAINER_NAME.equals(this.containerName)) {
            nativeJdbcExtractor = new WebSphereNativeJdbcExtractor();
        }
        if (nativeJdbcExtractor == null) {
            throw new IllegalArgumentException("The Web Sever Container:" + this.containerName + " is not support!");
        }
        Connection nativeConnection = nativeJdbcExtractor.getNativeConnection(conn);
        return nativeConnection;
    }
}

