/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation;

import aurora.presentation.IResourceUrlMapper;
import aurora.presentation.PresentationManager;
import aurora.presentation.ViewComponentPackage;
import aurora.service.http.WebContextInit;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uncertain.core.UncertainEngine;

public class ResourceDispatchServlet
extends HttpServlet
implements IResourceUrlMapper {
    private static final long serialVersionUID = -4772573956894794840L;
    public static final int BUFFER_SIZE = 10000;
    ServletConfig mConfig;
    ServletContext mServletContext;
    PresentationManager mPresentationManager;
    UncertainEngine mUncertainEngine;
    String mBasePath = "resource";

    private static void setString(StringBuffer buf, String content) {
        if (content == null) {
            throw new IllegalArgumentException();
        }
        buf.setLength(0);
        buf.append(content);
    }

    private static void parseRequestLine(String root_path, String uri, StringBuffer package_name, StringBuffer theme_name, StringBuffer resource) {
        int begin_id = uri.indexOf(root_path) + root_path.length();
        int end_id = uri.indexOf(47, begin_id + 1);
        if (begin_id < 0 || end_id < 0) {
            throw new IllegalArgumentException();
        }
        if (begin_id >= end_id) {
            throw new IllegalArgumentException();
        }
        ResourceDispatchServlet.setString(package_name, uri.substring(++begin_id, end_id));
        String file_name = uri.substring(end_id + 1);
        int theme_end_id = file_name.indexOf(47);
        ResourceDispatchServlet.setString(theme_name, file_name.substring(0, theme_end_id));
        ResourceDispatchServlet.setString(resource, file_name.substring(theme_end_id + 1));
    }

    private void initInternal() throws ServletException {
        if (this.mPresentationManager == null) {
            if (this.mUncertainEngine == null) {
                this.mUncertainEngine = WebContextInit.getUncertainEngine(this.mServletContext);
                if (this.mUncertainEngine == null) {
                    throw new ServletException("Can't get uncertain engine from servlet context");
                }
            }
            this.mPresentationManager = (PresentationManager)this.mUncertainEngine.getObjectRegistry().getInstanceOfType(PresentationManager.class);
            if (this.mPresentationManager == null) {
                throw new ServletException("Can't get PresentationManager instance from UncertainEngine");
            }
            this.mPresentationManager.setResourceUrlMapper(this);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doService(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doService(req, resp);
    }

    public void doService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String root_path = request.getServletPath();
        String uri = request.getRequestURI();
        StringBuffer package_name = new StringBuffer();
        StringBuffer theme = new StringBuffer();
        StringBuffer resource = new StringBuffer();
        try {
            ResourceDispatchServlet.parseRequestLine(root_path, uri, package_name, theme, resource);
            ViewComponentPackage pkg = this.mPresentationManager.getPackage(package_name.toString());
            if (pkg == null) {
                throw new IllegalArgumentException();
            }
            File rf = pkg.getResourceFile(theme.toString(), resource.toString());
            if (rf == null) {
                throw new IllegalArgumentException();
            }
            this.writeResponseFile(rf, response);
        }
        catch (IllegalArgumentException ex) {
            response.sendError(404);
        }
    }

    public void writeResponseFile(File resource, HttpServletResponse response) throws IOException {
        String mime_type = this.mServletContext.getMimeType(resource.getPath());
        if (mime_type != null) {
            response.setContentType(mime_type);
        }
        response.setContentLength((int)resource.length());
        FileInputStream fis = null;
        ServletOutputStream ois = null;
        try {
            fis = new FileInputStream(resource);
            ois = response.getOutputStream();
            byte[] buf = new byte[10000];
            int off = 0;
            while ((off = fis.read(buf)) != -1) {
                ois.write(buf, 0, off);
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public void init(ServletConfig config) throws ServletException {
        this.mConfig = config;
        this.mServletContext = config.getServletContext();
        this.initInternal();
        String p = config.getInitParameter("basePath");
        if (p != null) {
            this.mBasePath = p;
        }
    }

    @Override
    public String getResourceUrl(String package_name, String theme, String resource_path) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.mBasePath);
        buf.append("/");
        buf.append(package_name);
        buf.append("/");
        buf.append(theme);
        buf.append("/");
        buf.append(resource_path);
        return buf.toString();
    }
}

