/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Grid;
import aurora.presentation.component.std.config.TreeConfig;
import java.io.IOException;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.ocm.IObjectRegistry;

public class DynamicTreeGrid
extends Grid {
    public static final String VERSION = "$Revision: 7377 $";

    public DynamicTreeGrid(IObjectRegistry registry) {
        super(registry);
    }

    @Override
    public void onPreparePageContent(BuildSession session, ViewContext context) throws IOException {
        super.onPreparePageContent(session, context);
        this.addStyleSheet(session, context, "grid/Grid-min.css");
        this.addStyleSheet(session, context, "tree/Tree-min.css");
        this.addStyleSheet(session, context, "treegrid/TreeGrid-min.css");
        this.addJavaScript(session, context, "tree/Tree-min.js");
        this.addJavaScript(session, context, "tree/DynamicTree-min.js");
        this.addJavaScript(session, context, "treegrid/TreeGrid-min.js");
        this.addJavaScript(session, context, "treegrid/DynamicTreeGrid-min.js");
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        super.onCreateViewContent(session, context);
        Map map = context.getMap();
        CompositeMap view = context.getView();
        CompositeMap model = context.getModel();
        TreeConfig tc = TreeConfig.getInstance(view);
        if (session.getContextPath() != null) {
            this.addConfig("context", String.valueOf(session.getContextPath()) + "/");
        }
        this.addConfig("displayfield", tc.getDisplayField(model));
        if (tc.getRenderer() != null) {
            this.addConfig("renderer", tc.getRenderer());
        }
        this.addConfig("idfield", tc.getIdField(model));
        this.addConfig("parentfield", tc.getParentField(model));
        this.addConfig("showcheckbox", new Boolean(tc.isShowCheckBox()));
        this.addConfig("checkfield", tc.getCheckField());
        this.addConfig("expandfield", tc.getExpandField());
        this.addConfig("sequencefield", tc.getSequenceField(model));
        this.addConfig("iconfield", tc.getIconField());
        map.put("config", this.getConfigString());
    }
}

