/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.component.std.HBox;
import aurora.presentation.component.std.config.FieldGroupConfig;
import java.util.Iterator;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.ocm.IObjectRegistry;

public class FieldGroup
extends HBox {
    public static final String VERSION = "$Revision: 8392 $";

    public FieldGroup(IObjectRegistry registry) {
        super(registry);
    }

    @Override
    protected void beforeBuildCell(BuildSession session, CompositeMap model, CompositeMap view, CompositeMap field) throws Exception {
        FieldGroupConfig fgc = FieldGroupConfig.getInstance(view);
        int padding = fgc.getPadding(model, 3);
        view.putInt("padding", 0);
        Iterator it = view.getChildIterator();
        Integer fieldHeight = fgc.getFieldHeight(model);
        String fontStyle = fgc.getFontStyle(model);
        while (it.hasNext()) {
            CompositeMap child = (CompositeMap)it.next();
            if (child.getString("height") == null && fieldHeight != null) {
                child.putInt("height", fieldHeight);
            }
            String fieldFontStyle = TextParser.parse(child.getString("fontstyle"), model);
            if (fontStyle != null && fieldFontStyle == null) {
                child.putString("fontstyle", fontStyle);
            }
            child.putString("style", "margin-right:" + padding + "px;" + child.getString("style"));
        }
    }
}

