/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.application.ApplicationViewConfig;
import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Component;
import aurora.presentation.component.std.config.GridBoxConfig;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import uncertain.composite.CompositeMap;
import uncertain.ocm.IObjectRegistry;

public class GridBox
extends Component {
    public static final String VERSION = "$Revision: 8425 $";
    private static final String DEFAULT_CLASS = "item-gridbox-wrap";

    public GridBox(IObjectRegistry registry) {
        super(registry);
    }

    @Override
    public void onPreparePageContent(BuildSession session, ViewContext context) throws IOException {
        super.onPreparePageContent(session, context);
        this.addStyleSheet(session, context, "gridbox/GridBox-min.css");
        this.addJavaScript(session, context, "gridbox/GridBox-min.js");
    }

    @Override
    protected int getDefaultWidth() {
        return -1;
    }

    @Override
    protected String getDefaultClass(BuildSession session, ViewContext context) {
        return DEFAULT_CLASS;
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        super.onCreateViewContent(session, context);
        ApplicationViewConfig view_config = this.mApplicationConfig.getApplicationViewConfig();
        CompositeMap view = context.getView();
        CompositeMap model = context.getModel();
        Map map = context.getMap();
        GridBoxConfig gbc = GridBoxConfig.getInstance(view);
        String labelSeparator = gbc.getLabelSeparator() == null ? view_config.getDefaultLabelSeparator() : gbc.getLabelSeparator();
        this.processColumns(gbc.getColumns().getChilds());
        boolean underBox = gbc.getUnderBox();
        if (underBox) {
            this.addConfig("underbox", Boolean.TRUE);
        }
        this.addConfig("column", new Integer(gbc.getColumn()));
        int padding = gbc.getPadding(model, 3);
        this.addConfig("padding", new Integer(padding));
        this.addConfig("tabindex", gbc.getTabIndex());
        this.addConfig("labelseparator", labelSeparator);
        this.createEditors(session, context);
        map.put("config", this.getConfigString());
    }

    private void processColumns(List children) {
        Iterator it = children.iterator();
        JSONArray jsons = new JSONArray();
        while (it.hasNext()) {
            CompositeMap column = (CompositeMap)it.next();
            jsons.put(new JSONObject(column));
        }
        this.addConfig("columns", jsons);
    }

    private void createEditors(BuildSession session, ViewContext context) throws IOException {
        CompositeMap view = context.getView();
        Map map = context.getMap();
        CompositeMap model = context.getModel();
        CompositeMap editors = view.getChild("editors");
        StringBuffer sb = new StringBuffer();
        if (editors != null && editors.getChilds() != null) {
            Iterator it = editors.getChildIterator();
            while (it.hasNext()) {
                CompositeMap editor = (CompositeMap)it.next();
                editor.put("tabindex", new Integer(-1));
                editor.put("style", "position:absolute;left:-1000px;top:-1000px;");
                try {
                    sb.append(session.buildViewAsString(model, editor));
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        }
        map.put("editors", sb.toString());
    }
}

