/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Field;
import aurora.presentation.component.std.config.InputFieldConfig;
import java.io.IOException;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.ocm.IObjectRegistry;

public class InputField
extends Field {
    public static final String VERSION = "$Revision: 8395 $";
    protected static final String CLASSNAME_EMPTYTEXT = "item-emptyText";

    public InputField(IObjectRegistry registry) {
        super(registry);
    }

    @Override
    protected String getDefaultClass(BuildSession session, ViewContext context) {
        CompositeMap view = context.getView();
        InputFieldConfig ifc = new InputFieldConfig();
        ifc.initialize(view);
        Map map = context.getMap();
        String wrapClass = super.getDefaultClass(session, context);
        String emptyText = ifc.getEmptyText();
        String value = (String)map.get("value");
        if (!"".equals(emptyText) && "".equals(value)) {
            wrapClass = String.valueOf(wrapClass) + " item-emptyText";
        }
        return wrapClass;
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        String fontStyle;
        boolean isAutoSelect;
        boolean isTranChara;
        super.onCreateViewContent(session, context);
        CompositeMap view = context.getView();
        CompositeMap model = context.getModel();
        InputFieldConfig ifc = new InputFieldConfig();
        ifc.initialize(view);
        Map map = context.getMap();
        Integer width = (Integer)map.get("width");
        map.put("inputwidth", new Integer(width - 3));
        Integer maxlength = ifc.getMaxLength();
        if (maxlength != null) {
            this.addConfig("maxlength", maxlength);
        }
        if (!(isTranChara = ifc.isTransformCharacter())) {
            this.addConfig("transformcharacter", isTranChara);
        }
        if (!(isAutoSelect = ifc.isAutoSelect())) {
            this.addConfig("autoselect", isAutoSelect);
        }
        String value = (String)map.get("value");
        String emptyText = ifc.getEmptyText(session, model);
        if (!"".equals(emptyText) && "".equals(value)) {
            map.put("value", emptyText);
            this.addConfig("emptytext", emptyText);
        }
        if ((fontStyle = ifc.getFontStyle(model)) != null) {
            map.put("fontstyle", fontStyle);
        }
        this.addConfig("editable", ifc.isEditable());
    }
}

