/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Component;
import aurora.presentation.component.std.config.MenuTreeConfig;
import java.io.IOException;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.ocm.IObjectRegistry;

public class MenuTree
extends Component {
    public static final String VERSION = "$Revision: 8416 $";
    public static final String CONFIG_CONTEXT = "context";
    private static final String DEFAULT_CLASS = "item-menu-tree";

    public MenuTree(IObjectRegistry registry) {
        super(registry);
    }

    @Override
    protected String getDefaultClass(BuildSession session, ViewContext context) {
        return DEFAULT_CLASS;
    }

    @Override
    protected int getDefaultWidth() {
        return -1;
    }

    @Override
    protected int getDefaultHeight() {
        return -1;
    }

    @Override
    public void onPreparePageContent(BuildSession session, ViewContext context) throws IOException {
        super.onPreparePageContent(session, context);
        this.addStyleSheet(session, context, "menutree/MenuTree-min.css");
        this.addJavaScript(session, context, "menutree/MenuTree-min.js");
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        super.onCreateViewContent(session, context);
        Map map = context.getMap();
        CompositeMap view = context.getView();
        CompositeMap model = context.getModel();
        MenuTreeConfig mtc = MenuTreeConfig.getInstance(view);
        if (mtc.isShowRoot()) {
            this.createRootIcon(mtc, map, model);
        }
        map.put("bindtarget", mtc.getBindTarget());
        this.addConfig("displayfield", mtc.getDisplayField());
        if (mtc.getRenderer() != null) {
            this.addConfig("renderer", mtc.getRenderer());
        }
        this.addConfig("idfield", mtc.getIdField());
        this.addConfig("parentfield", mtc.getParentField());
        this.addConfig("sequencefield", mtc.getSequenceField());
        map.put("config", this.getConfigString());
    }

    private void createRootIcon(MenuTreeConfig mtc, Map map, CompositeMap model) {
        String icon = TextParser.parse(mtc.getRootIcon(), model);
        String iconwidth = mtc.getIconWidth();
        String iconheight = mtc.getIconHeight();
        StringBuffer sb = new StringBuffer("<thead>");
        sb.append("<tr>");
        sb.append("<td width='" + iconwidth + "'>");
        sb.append("<img border='0' width='" + iconwidth + "' height='" + iconheight + "' src='" + icon + "' class='menu-tree-icon' usemap='" + mtc.getIconMap() + "'></img>");
        sb.append("</td>");
        sb.append("<td></td>");
        sb.append("</tr>");
        sb.append("</thead>");
        map.put("rooticon", sb.toString());
        sb = new StringBuffer("<td valign='top'>");
        sb.append("<div style='margin-left:" + mtc.getRootLineOffset() + "px' class='menu-tree-line-left-bottom'>");
        sb.append("</td>");
        map.put("rootline", sb.toString());
    }
}

