/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.application.ApplicationViewConfig;
import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Component;
import aurora.presentation.component.std.config.RadioConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.ocm.IObjectRegistry;

public class Radio
extends Component {
    public static final String VERSION = "$Revision: 7797 $";
    private static final String DEFAULT_CLASS = "item-radio";

    @Override
    protected String getDefaultClass(BuildSession session, ViewContext context) {
        return DEFAULT_CLASS;
    }

    public Radio(IObjectRegistry registry) {
        super(registry);
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext view_context) throws IOException {
        CompositeMap options;
        super.onCreateViewContent(session, view_context);
        Map map = view_context.getMap();
        CompositeMap model = view_context.getModel();
        CompositeMap view = view_context.getView();
        RadioConfig rc = RadioConfig.getInstance(view);
        String layout = rc.getLayout();
        String labelField = rc.getLabelField();
        String valueField = rc.getValueField();
        CompositeMap items = rc.getItems();
        if (items != null) {
            try {
                this.createOptions(session, view, map, items, layout, labelField, valueField, rc.getLabelExpression());
            }
            catch (JSONException e) {
                throw new IOException(e);
            }
        }
        String ds = rc.getOptions();
        if (ds != null && (options = (CompositeMap)model.getObject(ds)) != null) {
            try {
                this.createOptions(session, view, map, options, layout, labelField, valueField, rc.getLabelExpression());
            }
            catch (JSONException e) {
                throw new IOException(e);
            }
        }
        this.addConfig("valueField", valueField);
        map.put("tabindex", rc.getTabIndex());
        map.put("config", this.getConfigString());
    }

    private void createOptions(BuildSession session, CompositeMap view, Map map, CompositeMap items, String layout, String labelField, String valueField, String expression) throws JSONException {
        ApplicationViewConfig view_config;
        StringBuffer sb = new StringBuffer();
        List children = items.getChilds();
        ArrayList<JSONObject> options = new ArrayList<JSONObject>();
        String mDefaultRadioSeparator = null;
        if (this.mApplicationConfig != null && (view_config = this.mApplicationConfig.getApplicationViewConfig()) != null) {
            mDefaultRadioSeparator = view_config.getDefaultRadioSeparator();
        }
        if (children != null) {
            for (CompositeMap item : children) {
                String label = expression != null ? TextParser.parse(expression, item) : item.getString(labelField, "");
                label = session.getLocalizedPrompt(label);
                String value = item.getString(valueField, "");
                JSONObject option = new JSONObject(item);
                options.add(option);
                String radioSeparator = view.getString("radioseparator", mDefaultRadioSeparator == null ? ":" : mDefaultRadioSeparator);
                if (!"".equals(label)) {
                    label = String.valueOf(radioSeparator) + label;
                }
                sb.append("<div class='item-radio-option'  style='text-align:left;");
                if ("horizontal".equalsIgnoreCase(layout)) {
                    sb.append("float:left'");
                } else {
                    sb.append("'");
                    map.put("height", null);
                }
                sb.append(" itemvalue='" + value + "'>");
                sb.append("<div class='item-radio-img'></div>");
                sb.append("<label class='item-radio-lb'>" + label + "</label>");
                sb.append("</div>");
            }
        }
        this.addConfig("options", new JSONArray(options));
        map.put("options", sb.toString());
    }
}

