/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Component;
import aurora.presentation.component.std.IDGenerator;
import aurora.presentation.component.std.config.SwitchCardConfig;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.ocm.IObjectRegistry;

public class SwitchCard
extends Component {
    public static final String VERSION = "$Revision: 8425 $";
    private static final String DEFAULT_CLASS = "layout-switchcard";
    private static final String REF = "ref";
    private static final String VALUE = "value";
    private static final String HIDDEN = "hidden";

    public SwitchCard(IObjectRegistry registry) {
        super(registry);
    }

    @Override
    protected String getDefaultClass(BuildSession session, ViewContext context) {
        return DEFAULT_CLASS;
    }

    @Override
    public void onPreparePageContent(BuildSession session, ViewContext context) throws IOException {
        super.onPreparePageContent(session, context);
        this.addJavaScript(session, context, "switchcard/SwitchCard-min.js");
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        super.onCreateViewContent(session, context);
        Map map = context.getMap();
        map.put("cards", this.createCards(session, context));
        map.put("config", this.getConfigString());
    }

    private String createCards(BuildSession session, ViewContext context) throws IOException {
        List childs;
        CompositeMap view = context.getView();
        SwitchCardConfig pc = SwitchCardConfig.getInstance(view);
        Map map = context.getMap();
        CompositeMap portals = pc.getCards();
        StringBuffer sb = new StringBuffer();
        JSONArray jsons = new JSONArray();
        if (portals != null && (childs = portals.getChilds()) != null) {
            for (CompositeMap card : childs) {
                sb.append(this.createCard(session, context, card));
                jsons.put(new JSONObject(card));
            }
        }
        this.addConfig("items", jsons);
        return sb.toString();
    }

    private StringBuffer createCard(BuildSession session, ViewContext context, CompositeMap card) throws IOException {
        CompositeMap model = context.getModel();
        StringBuffer sb = new StringBuffer();
        String ref = card.getString(REF, "");
        String value = card.getString(VALUE, "");
        boolean hidden = card.getBoolean(HIDDEN, true);
        sb.append("<div class='switchcard-body' style='display:" + (hidden ? "none" : "") + "' case='" + value + "' url='" + ref + "'");
        if ("".equals(ref)) {
            String hostid = IDGenerator.getInstance().generate();
            sb.append(" host_id='" + hostid + "'>");
            List cardChilds = card.getChilds();
            if (cardChilds != null) {
                for (CompositeMap cardChild : cardChilds) {
                    cardChild.putString("hostid", hostid);
                    try {
                        sb.append(session.buildViewAsString(model, cardChild));
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                }
            } else if (card.getText() != null && !"".equals(card.getText())) {
                sb.append(card.getText());
            }
        } else {
            sb.append(">");
        }
        card.putString(REF, TextParser.parse(ref, model));
        sb.append("</div>");
        return sb;
    }
}

