/*
 * Decompiled with CFR 0.152.
 */
package uncertain.cache;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import uncertain.cache.ICache;
import uncertain.cache.ICacheClone;
import uncertain.cache.MapBasedCacheMBean;
import uncertain.mbean.MBeanUtil;

public class MapBasedCache
implements ICache,
MapBasedCacheMBean,
ICacheClone {
    public static final int DEFAULT_CACHE_SIZE = 1000;
    String mName;
    long mRequestCount = 0L;
    long mHitCount = 0L;
    long mUpdateCount = 0L;
    HashMap mCacheMap;
    Date mCreationDate = new Date();

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public MapBasedCache() {
        this.mCacheMap = new HashMap(1000);
    }

    public MapBasedCache(HashMap map) {
        this.mCacheMap = map;
    }

    public MapBasedCache(int capacity) {
        this.mCacheMap = new HashMap(capacity);
    }

    public MapBasedCache(int capacity, float load_factor) {
        this.mCacheMap = new HashMap(capacity, load_factor);
    }

    public boolean setValue(Object key, Object value) {
        this.mCacheMap.put(key, value);
        ++this.mUpdateCount;
        return true;
    }

    public boolean setValue(Object key, int timeout, Object value) {
        this.setValue(key, value);
        return true;
    }

    public void remove(Object key) {
        this.mCacheMap.remove(key);
    }

    public Object getValue(Object key) {
        ++this.mRequestCount;
        Object v = this.mCacheMap.get(key);
        if (v != null) {
            ++this.mHitCount;
        }
        return v;
    }

    public void clear() {
        this.mCacheMap.clear();
        this.mHitCount = 0L;
        this.mUpdateCount = 0L;
    }

    public long getRequestCount() {
        return this.mRequestCount;
    }

    public long getHitCount() {
        return this.mHitCount;
    }

    public float getHitRate() {
        return this.mRequestCount == 0L ? 0.0f : (float)this.mHitCount / (float)this.mRequestCount;
    }

    public long getUpdateCount() {
        return this.mUpdateCount;
    }

    public int getSize() {
        return this.mCacheMap.size();
    }

    public Date getCreationDate() {
        return this.mCreationDate;
    }

    public String dumpMappings() {
        return MBeanUtil.dumpMap(this.mCacheMap);
    }

    public Object cacheClone() {
        return new MapBasedCache((HashMap)this.mCacheMap.clone());
    }

    public Iterator iterator() {
        return this.mCacheMap.entrySet().iterator();
    }

    public Map getMap() {
        return this.mCacheMap;
    }

    public void cacheCopy(ICacheClone cache) {
        if (cache instanceof MapBasedCache) {
            this.mCacheMap.putAll(((MapBasedCache)cache).getMap());
        } else {
            Iterator it = cache.iterator();
            if (it != null) {
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    this.mCacheMap.put(entry.getKey(), entry.getValue());
                }
            }
        }
    }
}

