/*
 * Decompiled with CFR 0.152.
 */
package uncertain.cache.action;

import uncertain.cache.CacheBuiltinExceptionFactory;
import uncertain.cache.ICache;
import uncertain.cache.INamedCacheFactory;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.proc.AbstractEntry;

public abstract class AbstractCacheAction
extends AbstractEntry {
    INamedCacheFactory mCacheFactory;
    String mCacheName;
    String mCacheKey;
    String dataPath;

    public String getCacheName() {
        return this.mCacheName;
    }

    public void setCacheName(String cacheName) {
        this.mCacheName = cacheName;
    }

    public String getCacheKey() {
        return this.mCacheKey;
    }

    public void setCacheKey(String cacheKey) {
        this.mCacheKey = cacheKey;
    }

    public AbstractCacheAction(INamedCacheFactory cacheFactory) {
        this.mCacheFactory = cacheFactory;
    }

    public ICache getCache() {
        if (this.mCacheName != null) {
            ICache cache = this.mCacheFactory.getNamedCache(this.mCacheName);
            if (cache == null) {
                throw CacheBuiltinExceptionFactory.createNamedCacheNotFound(this, this.mCacheName);
            }
            return cache;
        }
        return this.mCacheFactory.getCache();
    }

    public String getKey(CompositeMap context) {
        if (this.mCacheKey == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "cacheKey");
        }
        return TextParser.parse(this.mCacheKey, context);
    }

    public String getDataPath() {
        if (this.dataPath == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "dataPath");
        }
        return this.dataPath;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }
}

