/*
 * Decompiled with CFR 0.152.
 */
package uncertain.event;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import uncertain.composite.CompositeMap;
import uncertain.composite.CompositeUtil;
import uncertain.composite.IterationHandle;
import uncertain.event.HandleManager;
import uncertain.event.IEventDispatcher;
import uncertain.event.IEventHandle;
import uncertain.event.IEventListener;
import uncertain.event.RuntimeContext;
import uncertain.logging.DummyLogger;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.ClassRegistry;
import uncertain.ocm.OCManager;
import uncertain.proc.IExceptionHandle;
import uncertain.proc.IFeature;
import uncertain.proc.ParticipantRegistry;
import uncertain.proc.ProcedureRunner;

public class Configuration
implements Cloneable,
IEventDispatcher {
    public static final String LOGGING_TOPIC = "uncertain.event";
    ParticipantRegistry registry;
    OCManager ocManager;
    HandleManager handleManager;
    ClassRegistry reg;
    LinkedList config_list = new LinkedList();
    LinkedList participant_list = new LinkedList();
    LinkedList exception_handle_list = new LinkedList();
    HashMap feature_map;
    HashMap instance_map;
    int attach_result = 0;
    IEventHandle current_handle = null;
    int handle_flag = 0;
    Configuration parent;
    ILogger mLogger;

    public Configuration() {
        this(ParticipantRegistry.defaultInstance(), OCManager.getInstance());
    }

    public Configuration(OCManager m) {
        this(ParticipantRegistry.defaultInstance(), m);
    }

    public Configuration(ParticipantRegistry r, OCManager m) {
        this.registry = r;
        this.ocManager = m;
        this.reg = m.getClassRegistry();
        this.createHandleManager();
    }

    public void setHandleManager(HandleManager handleManager) {
        this.handleManager = handleManager;
    }

    public IEventHandle getCurrentHandle() {
        return this.current_handle;
    }

    public boolean isMapLoaded(CompositeMap data) {
        Integer value = CompositeUtil.uniqueHashCode(data);
        if (this.instance_map != null && this.instance_map.containsKey(value)) {
            return true;
        }
        return this.feature_map != null && this.feature_map.containsKey(value);
    }

    public void addParticipant(Object obj) {
        ILogger logger = this.ocManager.getLogger();
        if (obj != null) {
            Class<?> cls = obj.getClass();
            if (this.registry.isParticipant(cls) || obj instanceof IEventListener) {
                this.participant_list.add(obj);
                logger.log(Level.CONFIG, "Added participant instance " + cls.getName());
            } else {
                this.participant_list.add(obj);
            }
            if (obj instanceof IExceptionHandle) {
                this.addExceptionHandle((IExceptionHandle)obj);
            }
            if (this.handleManager != null) {
                this.handleManager.addParticipant(obj);
            }
        }
    }

    public Object createParticipant(CompositeMap container) {
        Object obj = this.ocManager.createObject(container);
        if (obj != null) {
            this.addParticipant(obj);
            if (this.instance_map == null) {
                this.instance_map = new HashMap();
            }
            this.instance_map.put(new Integer(CompositeUtil.uniqueHashCode(container)), obj);
        } else {
            this.ocManager.getLogger().log("Can't create instance from " + container.toXML());
        }
        return obj;
    }

    public Object getInstance(CompositeMap container) {
        if (this.instance_map == null) {
            return null;
        }
        return container == null ? this.instance_map.get(null) : this.instance_map.get(new Integer(CompositeUtil.uniqueHashCode(container)));
    }

    private void loadInternal(CompositeMap container) {
        Class cls = this.ocManager.getMappedClass(container);
        if (cls != null) {
            this.createParticipant(container);
        } else {
            Iterator it = container.getChildIterator();
            if (it != null) {
                while (it.hasNext()) {
                    CompositeMap child = (CompositeMap)it.next();
                    this.loadInternal(child);
                }
            }
        }
    }

    private List createFeatureList(CompositeMap config) {
        if (this.feature_map == null) {
            this.feature_map = new HashMap();
        }
        LinkedList fList = new LinkedList();
        this.feature_map.put(CompositeUtil.uniqueHashCode(config), fList);
        return fList;
    }

    private FeatureInstance createFeatureInstance(Class fClass, CompositeMap config) {
        if (fClass == null) {
            throw new NullPointerException("Class parameter is null");
        }
        FeatureInstance inst = new FeatureInstance();
        inst.attach_result = 0;
        Object fInst = null;
        try {
            fInst = this.ocManager.getObjectCreator().createInstance(fClass);
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't create instance of " + fClass.getName(), ex);
        }
        if (fInst == null) {
            throw new RuntimeException("Can't create instance of " + fClass.getName());
        }
        this.ocManager.populateObject(config, fInst);
        inst.feature_instance = fInst;
        if (fInst instanceof IFeature) {
            inst.attach_result = ((IFeature)fInst).attachTo(config, this);
            if (inst.attach_result == -1 || inst.attach_result == -2) {
                inst.feature_instance = null;
            }
        }
        if (inst.feature_instance != null) {
            this.addParticipant(inst.feature_instance);
        }
        return inst;
    }

    public void loadConfig(CompositeMap config) {
        this.loadConfig(config, null);
    }

    private void loadConfig(CompositeMap config, IterationHandle filter) {
        this.config_list.add(config);
        ConfigurationIterator handle = new ConfigurationIterator(filter);
        config.iterate(handle, true);
    }

    public void loadConfigList(Collection list) {
        for (CompositeMap config : list) {
            this.loadConfig(config);
        }
    }

    public List getParticipantList() {
        return this.participant_list;
    }

    public List getConfigList() {
        return this.config_list;
    }

    public List getAttachedFeatures(CompositeMap config) {
        return this.feature_map == null ? null : (List)this.feature_map.get(CompositeUtil.uniqueHashCode(config));
    }

    public Object getFeatureInstance(CompositeMap config, Class cls) {
        List l = this.getAttachedFeatures(config);
        if (l == null) {
            return null;
        }
        for (Object o : l) {
            if (!cls.isInstance(o)) continue;
            return o;
        }
        return null;
    }

    public void addExceptionHandle(IExceptionHandle handle) {
        this.exception_handle_list.add(handle);
    }

    public int fireEvent(String event_name, Object[] args) throws Exception {
        return this.fireEventInternal(event_name, args, null, null, this.handleManager);
    }

    public int fireEvent(String event_name, CompositeMap context, Object[] args) throws Exception {
        return this.fireEventInternal(event_name, args, null, context, this.handleManager);
    }

    public int fireEvent(String event_name, Object[] args, HandleManager handle_manager) throws Exception {
        return this.fireEventInternal(event_name, args, null, null, handle_manager);
    }

    public int fireEvent(String event_name, Object[] args, CompositeMap context, HandleManager handle_manager) throws Exception {
        return this.fireEventInternal(event_name, args, null, context, handle_manager);
    }

    public int fireEvent(String event_name, Object[] args, ProcedureRunner runner, HandleManager handle_manager) throws Exception {
        return this.fireEventInternal(event_name, args, runner, null, handle_manager);
    }

    protected ILogger getLogger(ProcedureRunner runner, CompositeMap context) {
        if (this.mLogger != null) {
            return this.mLogger;
        }
        ILogger logger = null;
        if (this.parent != null) {
            logger = this.parent.getLogger();
        }
        if (logger == null) {
            logger = runner != null ? runner.getLogger() : LoggingContext.getLogger(context, LOGGING_TOPIC);
        }
        if (logger == null) {
            logger = DummyLogger.getInstance();
        }
        return logger;
    }

    protected int fireEventInternal(String event_name, Object[] args, ProcedureRunner runner, CompositeMap context, HandleManager handle_manager) throws Exception {
        ILogger logger = this.getLogger(runner, context);
        this.current_handle = null;
        if (handle_manager == null) {
            return 0;
        }
        this.handle_flag = 0;
        Configuration parent_config = this;
        int i = 0;
        while (i <= 2) {
            ListIterator lsnr_it = handle_manager.getEventListenerIterator();
            do {
                if (lsnr_it != null) {
                    while (lsnr_it.hasNext()) {
                        IEventListener lnr = (IEventListener)lsnr_it.next();
                        this.handle_flag = lnr.onEvent(runner, i, event_name);
                        if (this.handle_flag == 1) break;
                        if (this.handle_flag != 2) continue;
                        return this.handle_flag;
                    }
                }
                if (parent_config != null) {
                    parent_config = parent_config.getParent();
                }
                lsnr_it = null;
                if (parent_config == null || parent_config.handleManager == null) continue;
                lsnr_it = parent_config.handleManager.getEventListenerIterator();
            } while (lsnr_it != null);
            ListIterator it = handle_manager.getEventHandleIterator(event_name, i);
            parent_config = this;
            do {
                if (it != null) {
                    while (it.hasNext()) {
                        IEventHandle handle;
                        this.handle_flag = 0;
                        this.current_handle = handle = (IEventHandle)it.next();
                        logger.log(Level.FINE, handle.toString());
                        this.handle_flag = runner != null ? handle.handleEvent(i, runner, args) : handle.handleEvent(i, context, args);
                        if (this.handle_flag == 1) break;
                        if (this.handle_flag != 2) continue;
                        return this.handle_flag;
                    }
                }
                it = null;
                if (parent_config != null) {
                    parent_config = parent_config.getParent();
                }
                if (parent_config == null || parent_config.handleManager == null) continue;
                it = parent_config.handleManager.getEventHandleIterator(event_name, i);
            } while (it != null);
            ++i;
        }
        return 0;
    }

    public List getExceptionHandles() {
        return this.exception_handle_list;
    }

    public HandleManager createHandleManager(CompositeMap config) {
        List features = null;
        if (this.feature_map == null) {
            return null;
        }
        features = this.getAttachedFeatures(config);
        if (features == null) {
            this.loadConfig(config);
            features = this.getAttachedFeatures(config);
            if (features == null) {
                return null;
            }
        }
        HandleManager manager = new HandleManager(this.registry);
        Iterator it = features.iterator();
        while (it.hasNext()) {
            manager.addParticipant(it.next());
        }
        return manager;
    }

    public RuntimeContext createEventContext(CompositeMap container) {
        RuntimeContext context = new RuntimeContext();
        context.initialize(container);
        context.setConfig(this);
        return context;
    }

    public RuntimeContext createEventContext() {
        return this.createEventContext(new CompositeMap("context"));
    }

    public HandleManager getHandleManager() {
        return this.handleManager;
    }

    public HandleManager createHandleManager() {
        this.handleManager = new HandleManager(this.registry);
        return this.handleManager;
    }

    public void addConfiguration(Configuration other) {
        if (this.handleManager != null) {
            Iterator it = other.getParticipantList().iterator();
            while (it.hasNext()) {
                this.handleManager.addParticipant(it.next());
            }
        }
        if (other.getExceptionHandles() != null) {
            this.addExceptionHandles(other.getExceptionHandles());
        }
    }

    public void addExceptionHandles(Collection handle_list) {
        if (this.exception_handle_list == null) {
            this.exception_handle_list = new LinkedList();
        }
        this.exception_handle_list.addAll(handle_list);
    }

    public void clear() {
        this.config_list.clear();
        this.participant_list.clear();
        this.exception_handle_list.clear();
        if (this.feature_map != null) {
            this.feature_map.clear();
        }
        if (this.instance_map != null) {
            this.instance_map.clear();
        }
        if (this.handleManager != null) {
            this.handleManager.clear();
            this.handleManager = null;
        }
    }

    public Configuration getParent() {
        return this.parent;
    }

    public void setParent(Configuration parent) {
        if (parent == this) {
            throw new IllegalArgumentException("Can't set parent to be self");
        }
        this.parent = parent;
    }

    public void setLogger(ILogger logger) {
        this.mLogger = logger;
    }

    public ILogger getLogger() {
        if (this.mLogger != null) {
            return this.mLogger;
        }
        if (this.parent != null) {
            return this.parent.getLogger();
        }
        return DummyLogger.getInstance();
    }

    private class ConfigurationIterator
    implements IterationHandle {
        IterationHandle dataFilter;

        public ConfigurationIterator(IterationHandle filter) {
            this.dataFilter = filter;
        }

        public int process(CompositeMap map) {
            int result = 0;
            if (Configuration.this.isMapLoaded(map)) {
                return 0;
            }
            if (this.dataFilter != null && (result = this.dataFilter.process(map)) == 2) {
                return result;
            }
            List fClassList = Configuration.this.reg.getFeatures(map.getNamespaceURI(), map.getName());
            if (fClassList != null) {
                List fInstList = Configuration.this.createFeatureList(map);
                for (Class fClass : fClassList) {
                    FeatureInstance inst = Configuration.this.createFeatureInstance(fClass, map);
                    if (inst.attach_result == -2) {
                        return -1;
                    }
                    if (inst.attach_result == -3) {
                        result = 1;
                    }
                    if (inst.feature_instance == null) continue;
                    fInstList.add(inst.feature_instance);
                }
            }
            if (Configuration.this.reg.getClassName(map) != null) {
                Configuration.this.loadInternal(map);
                return 1;
            }
            return result;
        }
    }

    private class FeatureInstance {
        int attach_result;
        Object feature_instance;

        private FeatureInstance() {
        }
    }
}

