/*
 * Decompiled with CFR 0.152.
 */
package uncertain.logging;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.ErrorManager;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import uncertain.composite.CompositeMap;
import uncertain.logging.ILogPathSettable;
import uncertain.ocm.IConfigurable;
import uncertain.util.FilePatternFilter;

public class BasicFileHandler
extends Handler
implements ILogPathSettable,
IConfigurable {
    FileWriter mWriter;
    String mBasePath;
    String mLogFilePrefix = "logfile";
    String mLogFilePostfix = "log";
    String mDateFormat = "yyyy-MM-dd";
    SimpleDateFormat mSimpleDateFormat;
    File mBasePathFile;
    boolean mSeparateByDate = true;
    boolean mAppend = true;
    String mCurrentLogFileName;

    public void beginConfigure(CompositeMap config) {
    }

    public void endConfigure() {
        if (this.mSeparateByDate && this.mSimpleDateFormat == null) {
            this.mSimpleDateFormat = new SimpleDateFormat(this.mDateFormat);
        }
    }

    void handleException(Exception thrown) {
        thrown.printStackTrace();
        ErrorManager em = this.getErrorManager();
        if (em != null) {
            em.error("Error when writting log file", thrown, -1);
        } else {
            thrown.printStackTrace();
        }
    }

    String getLogFileName() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.mLogFilePrefix);
        if (this.mSeparateByDate) {
            if (this.mSimpleDateFormat == null) {
                this.mSimpleDateFormat = new SimpleDateFormat(this.mDateFormat);
            }
            buf.append(this.mSimpleDateFormat.format(new Date()));
        }
        buf.append('.');
        buf.append(this.mLogFilePostfix);
        return buf.toString();
    }

    public void close() throws SecurityException {
        if (this.mWriter != null) {
            try {
                this.mWriter.close();
            }
            catch (IOException ex) {
                this.handleException(ex);
            }
        }
    }

    public void flush() {
        if (this.mWriter != null) {
            try {
                this.mWriter.flush();
            }
            catch (IOException ex) {
                this.handleException(ex);
            }
        }
    }

    public synchronized void publish(LogRecord record) {
        if (!super.isLoggable(record)) {
            return;
        }
        Formatter f = this.getFormatter();
        String content = f.format(record);
        try {
            this.checkLogFile();
            this.mWriter.write(content);
            this.flush();
        }
        catch (IOException ex) {
            this.handleException(ex);
        }
    }

    public void setLogPath(String path) {
        this.mBasePath = path;
        this.mBasePathFile = new File(path);
        if (!this.mBasePathFile.exists()) {
            throw new IllegalArgumentException("Invalid base file path:" + this.mBasePath);
        }
    }

    public String getLogPath() {
        return this.mBasePath;
    }

    public File getCurrentLogFile() {
        if (this.mBasePathFile == null) {
            return null;
        }
        File logFile = new File(this.mBasePathFile, this.getLogFileName());
        return logFile;
    }

    public String[] getFileList() {
        String pattern = String.valueOf(this.mLogFilePrefix) + ".*." + this.mLogFilePostfix;
        FilePatternFilter fpf = new FilePatternFilter(pattern);
        return this.mBasePathFile.list(fpf);
    }

    public void prepareLogFile() throws IOException {
        String path;
        File pathFile;
        this.close();
        this.mCurrentLogFileName = this.getLogFileName();
        File logFile = new File(this.mBasePathFile, this.mCurrentLogFileName);
        if (!logFile.exists() && this.mCurrentLogFileName.lastIndexOf("/") != -1 && !(pathFile = new File(this.mBasePathFile, path = this.mCurrentLogFileName.substring(0, this.mCurrentLogFileName.lastIndexOf("/")))).exists()) {
            pathFile.mkdirs();
        }
        this.mWriter = new FileWriter(logFile, this.mAppend);
    }

    void checkLogFile() throws IOException {
        if (this.mWriter == null) {
            this.prepareLogFile();
        }
        if (!this.mSeparateByDate) {
            return;
        }
        String file = this.getLogFileName();
        if (!file.equals(this.mCurrentLogFileName)) {
            this.prepareLogFile();
        }
    }

    public String getLogFilePrefix() {
        return this.mLogFilePrefix;
    }

    public void setLogFilePrefix(String logFilePrefix) {
        this.mLogFilePrefix = logFilePrefix;
    }

    public boolean getSeparateByDate() {
        return this.mSeparateByDate;
    }

    public void setSeparateByDate(boolean separateByDate) {
        this.mSeparateByDate = separateByDate;
    }

    public String getLogFilePostfix() {
        return this.mLogFilePostfix;
    }

    public void setLogFilePostfix(String logFilePostfix) {
        this.mLogFilePostfix = logFilePostfix;
    }

    public String getDateFormat() {
        return this.mDateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.mDateFormat = dateFormat;
    }

    public boolean getAppend() {
        return this.mAppend;
    }

    public void setAppend(boolean append) {
        this.mAppend = append;
    }
}

