/*
 * Decompiled with CFR 0.152.
 */
package uncertain.ocm;

import java.util.HashMap;
import uncertain.composite.CompositeMap;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.ocm.ClassMapping;
import uncertain.ocm.IClassLocator;
import uncertain.ocm.NamingUtil;

public class PackageMapping
extends AbstractLocatableObject
implements IClassLocator {
    String package_name;
    String name_space;
    HashMap class_mapping;
    boolean keep_original_input = false;

    public PackageMapping() {
    }

    public String toString() {
        return "package mapping: " + this.name_space + " -> " + this.package_name;
    }

    public PackageMapping(String _name_space, String _package_name) {
        this.name_space = _name_space;
        this.package_name = _package_name;
    }

    public void setPackageName(String name) {
        this.package_name = name;
    }

    public String getPackageName() {
        return this.package_name;
    }

    public boolean getKeepOriginalInput() {
        return this.keep_original_input;
    }

    public void setKeepOriginalInput(boolean keep_original_input) {
        this.keep_original_input = keep_original_input;
    }

    public String getNameSpace() {
        return this.name_space;
    }

    public void setNameSpace(String name_space) {
        this.name_space = name_space;
    }

    public void addClassMapping(ClassMapping m) {
        if (this.class_mapping == null) {
            this.class_mapping = new HashMap();
        }
        this.class_mapping.put(m.getElementName(), m);
    }

    public ClassMapping getClassMapping(String element_name) {
        if (this.class_mapping == null) {
            return null;
        }
        ClassMapping m = (ClassMapping)this.class_mapping.get(element_name);
        return m;
    }

    public String getClassName(CompositeMap config) {
        String element_name = config.getName();
        if (element_name == null) {
            return null;
        }
        ClassMapping m = this.getClassMapping(element_name);
        if (m != null) {
            if (m.getPackageName() == null) {
                return String.valueOf(this.package_name) + '.' + m.getClassName();
            }
            return m.getClassName(config);
        }
        String class_name = element_name;
        if (!this.keep_original_input) {
            class_name = NamingUtil.toClassName(element_name);
        }
        return String.valueOf(this.package_name) + '.' + class_name;
    }
}

