/*
 * Decompiled with CFR 0.152.
 */
package uncertain.proc;

import java.util.Iterator;
import java.util.LinkedList;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.ocm.IChildContainerAcceptable;
import uncertain.proc.AbstractEntry;
import uncertain.proc.Case;
import uncertain.proc.Procedure;
import uncertain.proc.ProcedureRunner;

public class Switch
extends AbstractEntry
implements IChildContainerAcceptable {
    String test;
    LinkedList caseList = new LinkedList();

    public void addCase(Case c) {
        this.caseList.add(c);
        c.setOwner(this);
    }

    public void run(ProcedureRunner runner) throws Exception {
        if (this.test == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "Test");
        }
        CompositeMap context = runner.getContext();
        Object obj = context.getObject(this.test);
        Iterator it = this.caseList.iterator();
        Procedure caseToRun = null;
        while (it.hasNext()) {
            Case theCase = (Case)it.next();
            String value = theCase.getEvaluatedValue(context);
            if ((value = TextParser.parse(value, context)) == null) {
                caseToRun = theCase;
                break;
            }
            if (obj == null) {
                if (!"null".equals(value)) continue;
                caseToRun = theCase;
                break;
            }
            if ("*".equals(value) && obj != null) {
                caseToRun = theCase;
                break;
            }
            if (!value.equals(obj.toString())) continue;
            caseToRun = theCase;
            break;
        }
        if (caseToRun != null) {
            caseToRun.run(runner);
        }
    }

    public String getTest() {
        return this.test;
    }

    public void setTest(String test) {
        this.test = test;
    }

    public Case getCaseByName(String name) {
        for (Case cs : this.caseList) {
            if (!name.equals(cs.getName())) continue;
            return cs;
        }
        return null;
    }

    public void addChild(CompositeMap config) {
        throw BuiltinExceptionFactory.createUnknownChild(config);
    }
}

