/*
 * Decompiled with CFR 0.152.
 */
package uncertain.util.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.util.reflect.BasicClassIterateHandle;
import uncertain.util.reflect.ClassIterator;

public class ClassMapHandle
extends BasicClassIterateHandle {
    CompositeMap cls;
    CompositeMap constructors;
    CompositeMap methods;
    CompositeMap interfaces;
    CompositeMap fields;

    public CompositeMap getRoot() {
        return this.cls;
    }

    public void onMethod(Class owner, Method m) {
        CompositeMap map = new CompositeMap("method");
        map.put("name", m.getName());
        map.put("return-type", m.getReturnType().getName());
        map.put("declaring-class", m.getDeclaringClass().getName());
        Class<?>[] params = m.getParameterTypes();
        int i = 0;
        while (i < params.length) {
            CompositeMap param = new CompositeMap("parameter");
            this.setupClassMap(params[i], param);
            map.addChild(param);
            ++i;
        }
        this.methods.addChild(map);
    }

    public void endIterate(Class cls) {
    }

    public void onConstructor(Class owner, Constructor constructor) {
        CompositeMap map = new CompositeMap("constructor");
        map.put("name", constructor.getName());
        Class<?>[] params = constructor.getParameterTypes();
        int i = 0;
        while (i < params.length) {
            CompositeMap param = new CompositeMap("parameter");
            this.setupClassMap(params[i], param);
            map.addChild(param);
            ++i;
        }
        this.constructors.addChild(map);
    }

    void setupClassMap(Class _cls, Map cls) {
        cls.put("name", _cls.getName());
        cls.put("super-class", _cls.getSuperclass());
        cls.put("package", _cls.getPackage());
    }

    public void beginIterate(Class _cls) {
        this.cls = new CompositeMap("class");
        this.setupClassMap(_cls, this.cls);
        this.interfaces = this.cls.createChild(null, null, "interfaces");
        this.fields = this.cls.createChild(null, null, "fields");
        this.constructors = this.cls.createChild(null, null, "constructors");
        this.methods = this.cls.createChild(null, null, "methods");
    }

    public void onInterface(Class owner, Class itf) {
        CompositeMap map = new CompositeMap("interface");
        this.setupClassMap(itf, map);
        this.interfaces.addChild(map);
    }

    public void onField(Class owner, Field fld) {
        CompositeMap map = new CompositeMap("field");
        map.put("name", fld.getName());
        map.put("type", fld.getType().getName());
        this.fields.addChild(map);
    }

    public static void main(String[] args) throws Exception {
        ClassIterator ci = new ClassIterator();
        ClassMapHandle hd = new ClassMapHandle();
        ci.iterate(BasicClassIterateHandle.class, hd);
        System.out.println(hd.getRoot().toXML());
    }
}

