/*
 * Decompiled with CFR 0.152.
 */
package uncertain.util.reflect;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import uncertain.util.reflect.BasicClassIterateHandle;
import uncertain.util.reflect.ClassIterator;
import uncertain.util.reflect.MethodFilter;

public class MethodCache
extends BasicClassIterateHandle {
    HashMap cache;
    ClassIterator iterator = new ClassIterator();
    LinkedList filters = new LinkedList();
    LinkedList method_list;

    public MethodCache() {
        this.cache = new HashMap();
    }

    public MethodCache(int size) {
        this.cache = new HashMap(size);
    }

    public void addFilter(MethodFilter flt) {
        this.filters.add(flt);
    }

    public List getFilters() {
        return this.filters;
    }

    public void setFilters(Collection flts) {
        this.filters.clear();
        this.addFilters(flts);
    }

    public void addFilters(Collection flts) {
        this.filters.addAll(flts);
    }

    public Collection loadClass(Class cls) throws SecurityException {
        this.iterator.iterate(cls, this);
        this.cache.put(cls, this.method_list);
        return this.method_list;
    }

    public synchronized Collection getMethods(Class cls) {
        Object obj = this.cache.get(cls);
        if (obj == null) {
            try {
                return this.loadClass(cls);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return (Collection)obj;
    }

    public void beginIterate(Class cls) {
        this.method_list = new LinkedList();
    }

    public void onMethod(Class owner, Method m) {
        for (MethodFilter filter : this.filters) {
            if (filter.accepts(owner, m)) continue;
            return;
        }
        this.method_list.add(m);
    }
}

