/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.dataimport;

import aurora.database.service.SqlServiceContext;
import aurora.plugin.csv.CsvParse;
import aurora.plugin.poi.ExcelParse;
import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceInstance;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class ImportExcel
extends AbstractEntry {
    public static final String DEFAULT_SUCCESS_FLAG = "/parameter/@ImportSuccess";
    public static final String XLS_KEY = ".xls";
    public static final String XLSX_KEY = ".xlsx";
    public static final String CSV_KEY = ".csv";
    public static final String TXT_KEY = ".txt";
    public String fileName;
    public String separator;
    public String header_id;
    public String user_id;
    public String job_id;
    public String template_code;
    public String attribute1;
    public String attribute2;
    public String attribute3;
    public String attribute4;
    public String attribute5;
    public String status_field = "/parameter/@ImportSuccess";

    public void run(ProcedureRunner runner) throws Exception {
        int result = -1;
        CompositeMap context = runner.getContext();
        this.validatePara(context);
        HttpServiceInstance serviceInstance = (HttpServiceInstance)ServiceInstance.getInstance((CompositeMap)context);
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload up = new ServletFileUpload((FileItemFactory)factory);
        SqlServiceContext sqlServiceContext = SqlServiceContext.createSqlServiceContext((CompositeMap)context);
        Connection conn = sqlServiceContext.getConnection();
        List items = up.parseRequest(serviceInstance.getRequest());
        for (FileItem fileItem : items) {
            if (fileItem.isFormField()) continue;
            this.fileName = fileItem.getName();
            String suffix = this.fileName.substring(this.fileName.lastIndexOf("."));
            CompositeMap data = this.parseFile(fileItem.getInputStream(), suffix.toLowerCase());
            result = this.save(conn, data);
        }
        context.putObject(this.status_field, (Object)result, true);
    }

    CompositeMap parseFile(InputStream is, String suffix) throws Exception {
        CompositeMap data = null;
        if (XLS_KEY.equals(suffix) || XLSX_KEY.equals(suffix)) {
            data = ExcelParse.parseFile(is, suffix);
        } else if (CSV_KEY.equals(suffix) || TXT_KEY.equals(suffix)) {
            if (this.separator == null) {
                throw new IllegalArgumentException("separator is undefined");
            }
            data = CsvParse.parseFile(is, this.separator);
        }
        return data;
    }

    void validatePara(CompositeMap context) {
        this.header_id = TextParser.parse((String)this.header_id, (CompositeMap)context);
        if (this.header_id == null && "".equals(this.header_id)) {
            throw new IllegalArgumentException("header_id is undefined");
        }
        this.user_id = TextParser.parse((String)this.user_id, (CompositeMap)context);
        if (this.user_id == null && "".equals(this.user_id)) {
            throw new IllegalArgumentException("user_id is undefined");
        }
        this.job_id = TextParser.parse((String)this.job_id, (CompositeMap)context);
        this.template_code = TextParser.parse((String)this.template_code, (CompositeMap)context);
        this.attribute1 = TextParser.parse((String)this.attribute1, (CompositeMap)context);
        this.attribute2 = TextParser.parse((String)this.attribute2, (CompositeMap)context);
        this.attribute3 = TextParser.parse((String)this.attribute3, (CompositeMap)context);
        this.attribute4 = TextParser.parse((String)this.attribute4, (CompositeMap)context);
        this.attribute5 = TextParser.parse((String)this.attribute5, (CompositeMap)context);
    }

    int save(Connection conn, CompositeMap data) throws SQLException {
        int is_success = 0;
        Statement pstm = null;
        CallableStatement cstm = null;
        ResultSet rs = null;
        try {
            String execute_pkg;
            cstm = conn.prepareCall("{call fnd_interface_load_pkg.ins_fnd_interface_headers(?,?,?,?,?,?,?,?,?,?,?)}");
            cstm.setLong(1, (long)new Long(this.header_id));
            if (this.job_id == null) {
                cstm.setNull(2, 2);
            } else {
                cstm.setLong(2, (long)new Long(this.job_id));
            }
            cstm.setString(3, "NEW");
            cstm.setString(4, this.user_id);
            cstm.setString(5, this.fileName);
            if (this.template_code == null) {
                cstm.setNull(6, 12);
            } else {
                cstm.setString(6, this.template_code);
            }
            if (this.attribute1 == null) {
                cstm.setNull(7, 12);
            } else {
                cstm.setString(7, this.attribute1);
            }
            if (this.attribute2 == null) {
                cstm.setNull(8, 12);
            } else {
                cstm.setString(8, this.attribute2);
            }
            if (this.attribute3 == null) {
                cstm.setNull(9, 12);
            } else {
                cstm.setString(9, this.attribute3);
            }
            if (this.attribute4 == null) {
                cstm.setNull(10, 12);
            } else {
                cstm.setString(10, this.attribute4);
            }
            if (this.attribute5 == null) {
                cstm.setNull(11, 12);
            } else {
                cstm.setString(11, this.attribute5);
            }
            cstm.execute();
            this.saveLines(conn, data);
            if (this.template_code != null && (rs = (pstm = conn.prepareStatement("select t.execute_pkg from fnd_interface_templates t where t.enabled_flag='Y' and t.template_code='" + this.template_code.trim() + "'")).executeQuery()).next() && (execute_pkg = rs.getString(1)) != null) {
                cstm = conn.prepareCall("{call " + execute_pkg + "(?,?)}");
                cstm.setLong(1, (long)new Long(this.header_id));
                cstm.registerOutParameter(2, 2);
                cstm.execute();
                Long result = cstm.getLong(2);
                is_success = result.intValue();
            }
        }
        finally {
            if (cstm != null) {
                cstm.close();
            }
            if (pstm != null) {
                pstm.close();
            }
        }
        return is_success;
    }

    void saveLines(Connection conn, CompositeMap data) throws SQLException {
        Iterator it = null;
        Iterator iterator = data.getChildIterator();
        while (iterator.hasNext()) {
            CompositeMap sheet = (CompositeMap)iterator.next();
            it = sheet.getChildIterator();
            int rownum = 0;
            while (it.hasNext()) {
                CompositeMap row = (CompositeMap)it.next();
                this.saveLine(conn, row, rownum++);
            }
        }
    }

    void saveLine(Connection conn, CompositeMap data, int rownum) throws SQLException {
        if (data.getLong((Object)"maxCell") == null) {
            return;
        }
        int maxcell = data.getLong((Object)"maxCell").intValue();
        StringBuffer stringBuffer = new StringBuffer("fnd_interface_load_pkg.ins_fnd_interface_lines(?,?,?,?,?,?,?");
        int i = 0;
        while (i < maxcell) {
            stringBuffer.append(",?");
            ++i;
        }
        stringBuffer.append(")");
        Statement cstm = null;
        try {
            cstm = conn.prepareCall("{call " + stringBuffer + "}");
            cstm.setLong(1, new Long(this.header_id));
            cstm.setNull(2, 12);
            cstm.setNull(3, 12);
            cstm.setString(4, this.user_id);
            cstm.setLong(5, rownum);
            cstm.setNull(6, 12);
            cstm.setNull(7, 2);
            int i2 = 0;
            while (i2 < maxcell) {
                String valueString = data.getString((Object)("C" + i2));
                if (valueString == null) {
                    cstm.setNull(8 + i2, 12);
                } else {
                    cstm.setString(8 + i2, valueString);
                }
                ++i2;
            }
            cstm.execute();
        }
        finally {
            if (cstm != null) {
                cstm.close();
            }
        }
    }

    public String getHeader_id() {
        return this.header_id;
    }

    public void setHeader_id(String header_id) {
        this.header_id = header_id;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getUser_id() {
        return this.user_id;
    }

    public void setUser_id(String user_id) {
        this.user_id = user_id;
    }

    public String getJob_id() {
        return this.job_id;
    }

    public void setJob_id(String job_id) {
        this.job_id = job_id;
    }

    public String getTemplate_code() {
        return this.template_code;
    }

    public void setTemplate_code(String template_code) {
        this.template_code = template_code;
    }

    public String getAttribute1() {
        return this.attribute1;
    }

    public void setAttribute1(String attribute1) {
        this.attribute1 = attribute1;
    }

    public String getAttribute2() {
        return this.attribute2;
    }

    public void setAttribute2(String attribute2) {
        this.attribute2 = attribute2;
    }

    public String getAttribute3() {
        return this.attribute3;
    }

    public void setAttribute3(String attribute3) {
        this.attribute3 = attribute3;
    }

    public String getAttribute4() {
        return this.attribute4;
    }

    public void setAttribute4(String attribute4) {
        this.attribute4 = attribute4;
    }

    public String getAttribute5() {
        return this.attribute5;
    }

    public void setAttribute5(String attribute5) {
        this.attribute5 = attribute5;
    }

    public String getStatus_field() {
        return this.status_field;
    }

    public void setStatus_field(String status_field) {
        if (status_field == null) {
            status_field = DEFAULT_SUCCESS_FLAG;
        }
        this.status_field = status_field;
    }

    public static void main(String[] args) {
        String pathname = "/Users/zoulei/Desktop/11.xls";
        File file = new File(pathname);
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            CompositeMap data = ExcelParse.parseFile(is, XLS_KEY);
            System.out.print(data.toXML());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

