/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.jms;

import aurora.plugin.jms.Event;
import aurora.plugin.jms.IMessageHandler;
import aurora.plugin.jms.JMSUtil;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import uncertain.composite.CompositeMap;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.exception.ConfigurationFileException;
import uncertain.exception.GeneralException;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IConfigurable;
import uncertain.ocm.IObjectRegistry;
import uncertain.util.resource.ILocatable;

public class Consumer
implements IConfigurable,
MessageListener,
ExceptionListener {
    private String topic;
    private String client;
    private CompositeMap config;
    private Session session;
    private Connection connection;
    private MessageConsumer messageConsumer;
    private Event[] events;
    private Map eventMap = new HashMap();
    private ILogger logger;
    private IObjectRegistry registry;
    private Map mHandlersMap;

    public Consumer(IObjectRegistry registry) {
        this.registry = registry;
    }

    public void init(ConnectionFactory factory, Map handlersMap) throws Exception {
        if (factory == null) {
            throw new IllegalArgumentException("ConnectionFactory can not be null");
        }
        if (handlersMap == null) {
            handlersMap = new HashMap();
        }
        this.mHandlersMap = handlersMap;
        if (this.topic == null) {
            throw BuiltinExceptionFactory.createAttributeMissing((ILocatable)this.config.asLocatable(), (String)"topic");
        }
        this.logger = LoggingContext.getLogger((String)"aurora.plugin.jms", (IObjectRegistry)this.registry);
        this.logger.log(Level.CONFIG, "init Consumer");
        this.connection = factory.createConnection();
        this.connection.setExceptionListener((ExceptionListener)this);
        if (this.client == null) {
            this.client = this.getAutoClient(this.topic);
        }
        this.connection.setClientID(this.client);
        this.session = this.connection.createSession(false, 1);
        Topic jmsTopic = this.session.createTopic(this.topic);
        this.logger.log(Level.CONFIG, "create Topic:{0}", new Object[]{this.topic});
        this.messageConsumer = this.session.createDurableSubscriber(jmsTopic, this.topic);
        this.messageConsumer.setMessageListener((MessageListener)this);
        int i = 0;
        while (i < this.events.length) {
            Event event = this.events[i];
            if (event.getHandler() != null) {
                this.eventMap.put(event.getMessage(), event.getHandler());
            }
            ++i;
        }
        this.connection.start();
        this.logger.log(Level.CONFIG, "start Consumer successfull!");
    }

    public void onShutdown() {
        JMSUtil.freeMessageConsumer(this.messageConsumer);
        JMSUtil.freeJMSSession(this.session);
        JMSUtil.freeJMSConnection(this.connection);
    }

    public void onMessage(Message message) {
        if (!(message instanceof TextMessage)) {
            ILocatable locatable = null;
            throw new GeneralException("aurora.plugin.amq.message_type_error", new Object[]{TextMessage.class.getName(), message.getClass().getCanonicalName()}, locatable);
        }
        String messageText = null;
        try {
            messageText = ((TextMessage)message).getText();
        }
        catch (JMSException e) {
            throw new GeneralException("aurora.plugin.amq.jmsexception_error", new Object[]{e.getMessage()}, (Throwable)e);
        }
        String handlerName = (String)this.eventMap.get(messageText);
        if (handlerName != null) {
            IMessageHandler handler = (IMessageHandler)this.mHandlersMap.get(handlerName);
            if (handler == null) {
                ConfigurationFileException ex = new ConfigurationFileException("aurora.plugin.amq.handler_not_found_error", new Object[]{handlerName}, this.config.asLocatable());
                this.logger.log(Level.SEVERE, "Error when handle jsm message", (Throwable)ex);
                throw ex;
            }
            handler.onMessage(message);
        }
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    public void setEvents(Event[] events) {
        this.events = events;
    }

    public Event[] getEvents() {
        return this.events;
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public String getAutoClient(String topic) {
        return String.valueOf(Calendar.getInstance().getTimeInMillis()) + (topic != null ? topic : "");
    }

    public void beginConfigure(CompositeMap config) {
        this.config = config;
    }

    public void endConfigure() {
    }

    public void onException(JMSException paramJMSException) {
        paramJMSException.printStackTrace();
        this.logger.log(Level.SEVERE, "JMSException:", (Throwable)paramJMSException);
    }
}

