/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.ntlm;

import aurora.plugin.ntlm.NtlmAuthenticator;
import aurora.plugin.ntlm.NtlmConfig;
import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceInstance;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jcifs.smb.NtlmPasswordAuthentication;
import uncertain.composite.CompositeMap;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.AbstractEntry;
import uncertain.proc.IProcedureManager;
import uncertain.proc.ProcedureRunner;

public class NtlmLogin
extends AbstractEntry {
    IProcedureManager procedureManager;
    IObjectRegistry mObjectRegistry;
    NtlmConfig ntlmConfig;
    ILogger mLogger;

    public NtlmLogin(NtlmConfig config, IProcedureManager procedureManager, IObjectRegistry registry) {
        this.ntlmConfig = config;
        this.procedureManager = procedureManager;
        this.mObjectRegistry = registry;
    }

    public void run(ProcedureRunner runner) throws Exception {
        ILogger mLogger = LoggingContext.getLogger((String)"aurora.plugin.ntlm", (IObjectRegistry)this.mObjectRegistry);
        CompositeMap context = runner.getContext();
        HttpServiceInstance svc = (HttpServiceInstance)ServiceInstance.getInstance((CompositeMap)context);
        HttpServletRequest httpRequest = svc.getRequest();
        String msg = httpRequest.getHeader("Authorization");
        if (httpRequest.getSession().getAttribute("user_id") == null) {
            if (msg == null || !msg.startsWith("NTLM")) {
                mLogger.info("excute procedure " + this.ntlmConfig.getProcedure());
                runner.call(this.procedureManager.loadProcedure(this.ntlmConfig.getProcedure()));
                Object result = context.getObject(this.ntlmConfig.getReturnPath());
                if (result == null) {
                    mLogger.log(Level.SEVERE, String.valueOf(this.ntlmConfig.getReturnPath()) + " is null");
                    return;
                }
                if (((CompositeMap)result).getChilds() != null) {
                    mLogger.info(String.valueOf(context.getString((Object)"service_name")) + " is not login required");
                    return;
                }
            }
            String username = "ADMIN";
            mLogger.info("username:" + username);
            context.putObject("/spnego/@user_name", (Object)username, true);
            context.putObject("/spnego/@status_code", (Object)"Y", true);
            runner.call(this.procedureManager.loadProcedure(this.ntlmConfig.getProcedure()));
            mLogger.info("doLogin context:" + context.toXML());
        } else if ("POST".equals(httpRequest.getMethod().toUpperCase()) && msg != null && msg.startsWith("NTLM")) {
            this.authenticate(runner);
        }
    }

    NtlmPasswordAuthentication authenticate(ProcedureRunner runner) {
        NtlmPasswordAuthentication ntlm;
        ILogger mLogger = LoggingContext.getLogger((String)"aurora.plugin.ntlm", (IObjectRegistry)this.mObjectRegistry);
        HttpServiceInstance svc = (HttpServiceInstance)ServiceInstance.getInstance((CompositeMap)runner.getContext());
        HttpServletRequest httpRequest = svc.getRequest();
        HttpServletResponse httpResponse = svc.getResponse();
        try {
            ntlm = new NtlmAuthenticator(this.ntlmConfig).authenticate(httpRequest, httpResponse);
            if (ntlm == null) {
                runner.stop();
                return null;
            }
        }
        catch (Exception e) {
            mLogger.log(Level.SEVERE, "NTLM authenticate fail", (Throwable)e);
            return null;
        }
        return ntlm;
    }
}

