/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.poi;

import aurora.i18n.ILocalizedMessageProvider;
import aurora.plugin.export.MergedHeader;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import uncertain.composite.CompositeMap;

public class ExcelExportImpl {
    ILocalizedMessageProvider localMsgProvider;
    Workbook wb;
    CompositeMap dataModel;
    CompositeMap headerConfig;
    List<CompositeMap> headerList;
    final int numberLimit = 65535;
    int headLevel;
    HSSFCellStyle headstyle;

    public ExcelExportImpl(ILocalizedMessageProvider localMsgProvider) {
        this.localMsgProvider = localMsgProvider;
    }

    public void createExcel(CompositeMap dataModel, CompositeMap column_config, OutputStream os) throws Exception {
        this.dataModel = dataModel;
        this.headerConfig = new MergedHeader((CompositeMap)column_config).conifg;
        this.wb = new HSSFWorkbook();
        this.setCellStyle(this.wb);
        this.createExcel();
        try {
            this.wb.write(os);
            os.flush();
        }
        finally {
            os.close();
        }
    }

    void setCellStyle(Workbook wb) {
        this.headstyle = (HSSFCellStyle)wb.createCellStyle();
        this.headstyle.getFont(wb).setFontName("\u5b8b\u4f53");
        this.headstyle.getFont(wb).setFontHeightInPoints((short)12);
        this.headstyle = (HSSFCellStyle)wb.createCellStyle();
        HSSFFont headfont = (HSSFFont)wb.createFont();
        headfont.setFontName("\u5b8b\u4f53");
        headfont.setBoldweight((short)700);
        headfont.setFontHeightInPoints((short)12);
        this.headstyle.setFont(headfont);
        this.headstyle.setAlignment((short)2);
        this.headstyle.setVerticalAlignment((short)1);
    }

    short getExcelAlign(String align) {
        int excelAlign = 0;
        if (align == null || "left".equalsIgnoreCase(align)) {
            excelAlign = 1;
        } else if ("right".equalsIgnoreCase(align)) {
            excelAlign = 3;
        } else if ("center".equalsIgnoreCase(align)) {
            excelAlign = 2;
        }
        return (short)excelAlign;
    }

    void createExcel() {
        Sheet sheet = null;
        Iterator iterator = this.dataModel.getChildIterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                this.headLevel = 0;
                sheet = this.wb.createSheet();
                this.createExcelHeader(sheet);
                this.createExcelTable(sheet, iterator);
            }
        } else {
            sheet = this.wb.createSheet();
            this.createExcelHeader(sheet);
        }
    }

    void createExcelHeader(Sheet sheet) {
        Row header = sheet.createRow(0);
        this.headerList = new LinkedList<CompositeMap>();
        this.generatExcelHead(this.headerConfig, sheet, header, -1);
    }

    void createExcelTable(Sheet sheet, Iterator iterator) {
        boolean is_setwidth = false;
        ++this.headLevel;
        sheet.createFreezePane(0, this.headLevel);
        int col = 0;
        while (iterator.hasNext()) {
            if (this.headLevel == 65535) break;
            CompositeMap object = (CompositeMap)iterator.next();
            Row row = sheet.getRow(this.headLevel);
            if (row == null) {
                row = sheet.createRow(this.headLevel);
            }
            Iterator<CompositeMap> it = this.headerList.iterator();
            while (it.hasNext()) {
                Cell cell = row.createCell(col);
                CompositeMap record = it.next();
                String text = object.getString((Object)record.getString((Object)"name"));
                HSSFCellStyle columnstyle = (HSSFCellStyle)this.wb.createCellStyle();
                columnstyle.setAlignment(this.getExcelAlign(record.getString((Object)"align")));
                cell.setCellType(1);
                cell.setCellStyle((CellStyle)columnstyle);
                if (text != null) {
                    cell.setCellValue((RichTextString)new HSSFRichTextString(text));
                }
                if (!is_setwidth) {
                    int width = record.getInt((Object)"width", 100);
                    sheet.setColumnWidth(col, (int)((short)((double)width * 35.7)));
                }
                ++col;
            }
            is_setwidth = true;
            col = 0;
            ++this.headLevel;
        }
    }

    String getPrompt(String key) {
        String promptString = this.localMsgProvider.getMessage(key);
        promptString = promptString == null ? key : promptString;
        return promptString;
    }

    int generatExcelHead(CompositeMap columnConfigs, Sheet sheet, Row header, int col) {
        int rownum = header.getRowNum();
        Iterator iterator = columnConfigs.getChildIterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                org.apache.poi.hssf.util.CellRangeAddress range;
                Iterator it;
                CompositeMap record = (CompositeMap)iterator.next();
                String title = this.getPrompt(record.getString((Object)"prompt"));
                Cell cell = header.createCell(++col);
                cell.setCellValue((RichTextString)new HSSFRichTextString(title));
                cell.setCellStyle((CellStyle)this.headstyle);
                int level = record.getInt((Object)"_level", 0);
                if (this.headLevel == 0) {
                    this.headLevel = level;
                }
                if ((it = record.getChildIterator()) != null) {
                    Long span = (Long)record.getObject("column/@_count");
                    range = new org.apache.poi.hssf.util.CellRangeAddress(rownum, rownum, col, col + span.intValue() - 1);
                    sheet.addMergedRegion((CellRangeAddress)range);
                    while (it.hasNext()) {
                        Row nextRow = sheet.getRow(rownum + 1);
                        if (nextRow == null) {
                            nextRow = sheet.createRow(rownum + 1);
                        }
                        CompositeMap object = (CompositeMap)it.next();
                        col = this.generatExcelHead(object, sheet, nextRow, col - 1);
                    }
                    continue;
                }
                this.headerList.add(record);
                if (level == 0) continue;
                range = new org.apache.poi.hssf.util.CellRangeAddress(rownum, rownum + level, col, col);
                sheet.addMergedRegion((CellRangeAddress)range);
            }
        }
        return col;
    }
}

