/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.poi;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import uncertain.composite.CompositeMap;

public class ExcelParse {
    public static CompositeMap parseFile(InputStream is, String suffix) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HSSFWorkbook wb = null;
        Sheet sheet = null;
        Row row = null;
        Cell cell = null;
        CompositeMap excelData = new CompositeMap();
        if (!".xls".equalsIgnoreCase(suffix)) {
            throw new Exception("filetype is undefined");
        }
        wb = new HSSFWorkbook(is);
        int i = 0;
        int sheetLength = wb.getNumberOfSheets();
        while (i < sheetLength) {
            sheet = wb.getSheetAt(i);
            CompositeMap sheetData = new CompositeMap("sheet");
            sheetData.put((Object)"name", (Object)sheet.getSheetName());
            int firstRow = sheet.getFirstRowNum();
            int lastRow = sheet.getLastRowNum();
            while (firstRow <= lastRow) {
                row = sheet.getRow(firstRow);
                CompositeMap rowData = new CompositeMap("row");
                if (row != null) {
                    int firstCell = row.getFirstCellNum();
                    short lastCell = row.getLastCellNum();
                    while (firstCell < lastCell) {
                        cell = row.getCell(firstCell);
                        if (cell != null) {
                            if (cell.getCellType() == 0) {
                                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                    rowData.put((Object)("C" + firstCell), (Object)sdf.format(cell.getDateCellValue()));
                                } else {
                                    rowData.put((Object)("C" + firstCell), (Object)cell.getNumericCellValue());
                                }
                            } else if (cell.getCellType() == 1) {
                                rowData.put((Object)("C" + firstCell), (Object)cell.toString());
                            } else if (cell.getCellType() != 3) {
                                rowData.put((Object)("C" + firstCell), (Object)"undefined");
                            }
                        }
                        ++firstCell;
                    }
                    rowData.putLong((Object)"maxCell", (long)row.getLastCellNum());
                }
                sheetData.addChild(rowData);
                ++firstRow;
            }
            excelData.addChild(sheetData);
            ++i;
        }
        return excelData;
    }
}

