/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sap.jco3;

import aurora.plugin.sap.jco3.InstanceConfig;
import aurora.plugin.sap.jco3.JCo3Provider;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import java.util.Properties;
import uncertain.core.IGlobalInstance;

public class SapConfig
implements IGlobalInstance {
    String defaultSid;

    public void addInstances(InstanceConfig[] instances) {
        JCo3Provider myProvider = new JCo3Provider();
        int l = instances.length;
        int i = 0;
        while (i < l) {
            InstanceConfig instance = instances[i];
            Properties connectProperties = new Properties();
            connectProperties.setProperty("jco.client.ashost", instance.getServer_ip());
            connectProperties.setProperty("jco.client.sysnr", instance.getSystem_number());
            connectProperties.setProperty("jco.client.client", instance.getSap_client());
            connectProperties.setProperty("jco.client.user", instance.getUserid());
            connectProperties.setProperty("jco.client.passwd", instance.getPassword());
            connectProperties.setProperty("jco.client.lang", instance.getDefault_lang());
            connectProperties.setProperty("jco.destination.peak_limit", Integer.toString(instance.getMax_conn()));
            myProvider.changeProperties(instance.getSid(), connectProperties);
            ++i;
        }
        if (l == 1) {
            this.defaultSid = instances[0].sid;
        }
    }

    public JCoDestination getJCoDestination(String sid) throws Exception {
        if (sid == null) {
            if (this.defaultSid != null) {
                sid = this.defaultSid;
            } else {
                throw new IllegalArgumentException("jco-invoke: sid attribute is null");
            }
        }
        return JCoDestinationManager.getDestination((String)sid);
    }
}

