/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sap.sync.idoc;

import aurora.plugin.sap.sync.idoc.ApplicationException;
import aurora.plugin.sap.sync.idoc.DataBaseUtil;
import aurora.plugin.sap.sync.idoc.IDocFile;
import aurora.plugin.sap.sync.idoc.IDocServerInstance;
import aurora.plugin.sap.sync.idoc.IDocXMLParser;
import com.sap.conn.idoc.IDocDocumentList;
import com.sap.conn.idoc.IDocXMLProcessor;
import com.sap.conn.idoc.jco.JCoIDoc;
import com.sap.conn.idoc.jco.JCoIDocHandler;
import com.sap.conn.idoc.jco.JCoIDocHandlerFactory;
import com.sap.conn.idoc.jco.JCoIDocServer;
import com.sap.conn.idoc.jco.JCoIDocServerContext;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.server.JCoServer;
import com.sap.conn.jco.server.JCoServerContext;
import com.sap.conn.jco.server.JCoServerContextInfo;
import com.sap.conn.jco.server.JCoServerErrorListener;
import com.sap.conn.jco.server.JCoServerExceptionListener;
import com.sap.conn.jco.server.JCoServerState;
import com.sap.conn.jco.server.JCoServerTIDHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.logging.Level;
import uncertain.logging.ILogger;

public class IDocServer {
    public JCoIDocServer iDocServer;
    private String serverName;
    private DataBaseUtil dbUtil;
    public LinkedList idocFils = new LinkedList();
    private IDocServerInstance iDocServerInstance;
    private ILogger logger;
    private int server_id = -1;

    public IDocServer(IDocServerInstance iDocServerInstance, String serverName) {
        this.iDocServerInstance = iDocServerInstance;
        this.serverName = serverName;
    }

    public void start() {
        this.logger = this.iDocServerInstance.getLogger();
        this.log("get database connection for " + this.serverName);
        try {
            this.dbUtil = new DataBaseUtil(this.iDocServerInstance.getRegistry(), this.logger);
        }
        catch (ApplicationException e1) {
            this.handleException(e1);
        }
        try {
            this.log("begin start IDocServer " + this.serverName + "...");
            this.iDocServer = JCoIDoc.getServer((String)this.serverName);
            this.log("get HistoryIdocs " + this.iDocServer.getProgramID());
            this.dbUtil.getHistoryIdocs(this.iDocServer.getProgramID(), this.idocFils);
        }
        catch (JCoException e) {
            this.handleException(String.valueOf(this.serverName) + " is not valid.", e);
        }
        catch (SQLException e) {
            this.handleException(" get HistoryIdocs " + this.iDocServer.getProgramID() + " failure!", e);
        }
        catch (ApplicationException e) {
            this.handleException(e);
        }
        MyIDocHandlerFactory idocHanlerFactory = new MyIDocHandlerFactory();
        this.iDocServer.setIDocHandlerFactory((JCoIDocHandlerFactory)idocHanlerFactory);
        this.iDocServer.setTIDHandler((JCoServerTIDHandler)new MyTidHandler());
        MyThrowableListener listener = new MyThrowableListener();
        this.iDocServer.addServerErrorListener((JCoServerErrorListener)listener);
        this.iDocServer.addServerExceptionListener((JCoServerExceptionListener)listener);
        this.log("getConnectionCount is " + this.iDocServer.getConnectionCount());
        if (this.iDocServer.getConnectionCount() == 0) {
            this.iDocServer.setConnectionCount(1);
        }
        try {
            this.server_id = this.dbUtil.registerSapServers(this.iDocServer);
            this.log("get server_id " + this.server_id);
            this.iDocServer.start();
            this.log("idocServer's status is " + this.iDocServer.getState());
            if (!JCoServerState.ALIVE.equals((Object)this.iDocServer.getState()) && !JCoServerState.STARTED.equals((Object)this.iDocServer.getState())) {
                this.log("unRegisterSapServers server_id " + this.server_id);
                if (this.dbUtil.getConnection() != null && !this.dbUtil.getConnection().isClosed()) {
                    this.dbUtil.unRegisterSapServers(this.server_id);
                    this.dbUtil.dispose();
                }
                return;
            }
            this.log("start IDocXMLParser ");
            IDocXMLParser parser = new IDocXMLParser(this);
            parser.start();
        }
        catch (SQLException e) {
            this.handleException(e);
        }
        this.log("IDocServer " + this.serverName + " start finished.");
    }

    public DataBaseUtil getDbUtil() {
        return this.dbUtil;
    }

    public void setDbUtil(DataBaseUtil dbUtil) {
        this.dbUtil = dbUtil;
    }

    public synchronized void addIdocFile(IDocFile file) {
        this.idocFils.addLast(file);
    }

    public synchronized IDocFile getIdocFile() {
        if (this.idocFils.size() <= 0) {
            return null;
        }
        IDocFile file = (IDocFile)this.idocFils.getFirst();
        this.idocFils.remove(0);
        return file;
    }

    public boolean isShutDown() {
        return !JCoServerState.ALIVE.equals((Object)this.iDocServer.getState());
    }

    public boolean isFinished() {
        return this.idocFils.size() <= 0;
    }

    public void log(String message) {
        if (this.logger != null) {
            this.logger.info(message);
        } else {
            System.out.println(message);
        }
    }

    public void log(Throwable e) {
        if (this.logger != null) {
            this.logger.log(Level.SEVERE, "", e);
        } else {
            e.printStackTrace();
        }
    }

    public int getServerId() {
        return this.server_id;
    }

    public void setServerId(int serverId) {
        this.server_id = serverId;
    }

    public boolean isDeleteImmediately() {
        return this.iDocServerInstance.isDeleteImmediately();
    }

    public void handleException(String message) {
        this.handleException(message);
    }

    public void handleException(Throwable e) {
        this.handleException("", e);
    }

    public void handleException(String message, Throwable e) {
        if (message == null && e == null) {
            return;
        }
        if (this.logger != null) {
            this.logger.log(Level.SEVERE, message, e);
        }
        try {
            this.dbUtil.getConnection().rollback();
            this.dbUtil.getConnection().setAutoCommit(true);
            this.dbUtil.stopSapServers(this.server_id);
        }
        catch (SQLException e1) {
            this.log("reportException:exception " + e1 + " failed!");
        }
        if (JCoServerState.ALIVE.equals((Object)this.iDocServer.getState()) || JCoServerState.STARTED.equals((Object)this.iDocServer.getState())) {
            this.log("stop iDocServer ");
            this.iDocServer.stop();
        }
        this.log("close dbconnection ");
        try {
            this.dbUtil.dispose();
        }
        catch (SQLException e1) {
            this.log("dispose dbUtil " + e1 + " failed!");
        }
        this.log("...........shutdown " + this.serverName + " finished.............. ");
        if (e != null) {
            throw new RuntimeException(message, e);
        }
        throw new RuntimeException(message);
    }

    class MyIDocHandler
    implements JCoIDocHandler {
        MyIDocHandler() {
        }

        public void handleRequest(JCoServerContext serverCtx, IDocDocumentList idocList) {
            FileOutputStream fos = null;
            OutputStreamWriter osw = null;
            try {
                try {
                    IDocXMLProcessor xmlProcessor = JCoIDoc.getIDocFactory().getIDocXMLProcessor();
                    String fileName = String.valueOf(serverCtx.getTID()) + "_idoc.xml";
                    String filePath = String.valueOf(IDocServer.this.iDocServerInstance.getIdocDir()) + File.separator + fileName;
                    IDocServer.this.log("receive idoc " + fileName);
                    fos = new FileOutputStream(filePath);
                    osw = new OutputStreamWriter((OutputStream)fos, "UTF8");
                    xmlProcessor.render(idocList, (Writer)osw, 7);
                    osw.flush();
                    int idoc_id = IDocServer.this.dbUtil.addIdoc(IDocServer.this.server_id, filePath);
                    IDocServer.this.log("add idoc_id " + idoc_id);
                    IDocServer.this.addIdocFile(new IDocFile(filePath, idoc_id, IDocServer.this.server_id));
                }
                catch (Throwable thr) {
                    IDocServer.this.handleException(thr);
                    try {
                        if (osw != null) {
                            osw.close();
                        }
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException e) {
                        IDocServer.this.handleException(e);
                    }
                }
            }
            finally {
                try {
                    if (osw != null) {
                        osw.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e) {
                    IDocServer.this.handleException(e);
                }
            }
        }
    }

    class MyIDocHandlerFactory
    implements JCoIDocHandlerFactory {
        private JCoIDocHandler handler;

        MyIDocHandlerFactory() {
            this.handler = new MyIDocHandler();
        }

        public JCoIDocHandler getIDocHandler(JCoIDocServerContext serverCtx) {
            return this.handler;
        }

        public JCoIDocHandler getIDocHandler() {
            return this.handler;
        }
    }

    class MyThrowableListener
    implements JCoServerErrorListener,
    JCoServerExceptionListener {
        MyThrowableListener() {
        }

        public void serverErrorOccurred(JCoServer server, String connectionId, JCoServerContextInfo ctx, Error error) {
            IDocServer.this.handleException(">>> Error occured on " + server.getProgramID() + " connection " + connectionId, error);
        }

        public void serverExceptionOccurred(JCoServer server, String connectionId, JCoServerContextInfo ctx, Exception error) {
            IDocServer.this.handleException(">>> Exception occured on " + server.getProgramID() + " connection " + connectionId, error);
        }
    }

    class MyTidHandler
    implements JCoServerTIDHandler {
        MyTidHandler() {
        }

        public boolean checkTID(JCoServerContext serverCtx, String tid) {
            IDocServer.this.log("checkTID called for TID=" + tid);
            return true;
        }

        public void confirmTID(JCoServerContext serverCtx, String tid) {
            IDocServer.this.log("confirmTID called for TID=" + tid);
        }

        public void commit(JCoServerContext serverCtx, String tid) {
            IDocServer.this.log("commit called for TID=" + tid);
        }

        public void rollback(JCoServerContext serverCtx, String tid) {
            IDocServer.this.log("rollback called for TID=" + tid);
        }
    }
}

